package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.FeatureGroupName
import scala.jdk.CollectionConverters.*
final case class ProcessingFeatureStoreOutput(
    featureGroupName: FeatureGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingFeatureStoreOutput = {
    import ProcessingFeatureStoreOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingFeatureStoreOutput
      .builder()
      .featureGroupName(
        FeatureGroupName.unwrap(featureGroupName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.ReadOnly =
    zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.wrap(buildAwsValue())
}
object ProcessingFeatureStoreOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingFeatureStoreOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingFeatureStoreOutput =
      zio.aws.sagemaker.model.ProcessingFeatureStoreOutput(featureGroupName)
    def featureGroupName: FeatureGroupName
    def getFeatureGroupName: ZIO[Any, Nothing, FeatureGroupName] =
      ZIO.succeed(featureGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingFeatureStoreOutput
  ) extends zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.ReadOnly {
    override val featureGroupName: FeatureGroupName =
      zio.aws.sagemaker.model.primitives
        .FeatureGroupName(impl.featureGroupName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingFeatureStoreOutput
  ): zio.aws.sagemaker.model.ProcessingFeatureStoreOutput.ReadOnly =
    new Wrapper(impl)
}
