package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.String256
import scala.jdk.CollectionConverters.*
final case class ModelMetadataFilter(
    name: zio.aws.sagemaker.model.ModelMetadataFilterType,
    value: String256
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilter = {
    import ModelMetadataFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilter
      .builder()
      .name(name.unwrap)
      .value(String256.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelMetadataFilter.ReadOnly =
    zio.aws.sagemaker.model.ModelMetadataFilter.wrap(buildAwsValue())
}
object ModelMetadataFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelMetadataFilter =
      zio.aws.sagemaker.model.ModelMetadataFilter(name, value)
    def name: zio.aws.sagemaker.model.ModelMetadataFilterType
    def value: String256
    def getName
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelMetadataFilterType] =
      ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String256] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilter
  ) extends zio.aws.sagemaker.model.ModelMetadataFilter.ReadOnly {
    override val name: zio.aws.sagemaker.model.ModelMetadataFilterType =
      zio.aws.sagemaker.model.ModelMetadataFilterType.wrap(impl.name())
    override val value: String256 =
      zio.aws.sagemaker.model.primitives.String256(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilter
  ): zio.aws.sagemaker.model.ModelMetadataFilter.ReadOnly = new Wrapper(impl)
}
