package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait FeatureType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.FeatureType
}
object FeatureType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.FeatureType
  ): zio.aws.sagemaker.model.FeatureType = value match {
    case software.amazon.awssdk.services.sagemaker.model.FeatureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureType.INTEGRAL =>
      val r = Integral
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureType.FRACTIONAL =>
      val r = Fractional
      r
    case software.amazon.awssdk.services.sagemaker.model.FeatureType.STRING =>
      val r = String
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureType =
      software.amazon.awssdk.services.sagemaker.model.FeatureType.UNKNOWN_TO_SDK_VERSION
  }
  case object Integral extends zio.aws.sagemaker.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureType =
      software.amazon.awssdk.services.sagemaker.model.FeatureType.INTEGRAL
  }
  case object Fractional extends zio.aws.sagemaker.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureType =
      software.amazon.awssdk.services.sagemaker.model.FeatureType.FRACTIONAL
  }
  case object String extends zio.aws.sagemaker.model.FeatureType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.FeatureType =
      software.amazon.awssdk.services.sagemaker.model.FeatureType.STRING
  }
}
