package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName
import scala.jdk.CollectionConverters.*
final case class DescribeModelQualityJobDefinitionRequest(
    jobDefinitionName: MonitoringJobDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest = {
    import DescribeModelQualityJobDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest
      .builder()
      .jobDefinitionName(
        MonitoringJobDefinitionName.unwrap(jobDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionRequest
      .wrap(buildAwsValue())
}
object DescribeModelQualityJobDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionRequest =
      zio.aws.sagemaker.model
        .DescribeModelQualityJobDefinitionRequest(jobDefinitionName)
    def jobDefinitionName: MonitoringJobDefinitionName
    def getJobDefinitionName: ZIO[Any, Nothing, MonitoringJobDefinitionName] =
      ZIO.succeed(jobDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest
  ) extends zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionRequest.ReadOnly {
    override val jobDefinitionName: MonitoringJobDefinitionName =
      zio.aws.sagemaker.model.primitives
        .MonitoringJobDefinitionName(impl.jobDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelQualityJobDefinitionRequest
  ): zio.aws.sagemaker.model.DescribeModelQualityJobDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
