package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{Database, Catalog, TableName}
import scala.jdk.CollectionConverters.*
final case class DataCatalogConfig(
    tableName: TableName,
    catalog: Catalog,
    database: Database
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataCatalogConfig = {
    import DataCatalogConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataCatalogConfig
      .builder()
      .tableName(TableName.unwrap(tableName): java.lang.String)
      .catalog(Catalog.unwrap(catalog): java.lang.String)
      .database(Database.unwrap(database): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataCatalogConfig.ReadOnly =
    zio.aws.sagemaker.model.DataCatalogConfig.wrap(buildAwsValue())
}
object DataCatalogConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataCatalogConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataCatalogConfig =
      zio.aws.sagemaker.model.DataCatalogConfig(tableName, catalog, database)
    def tableName: TableName
    def catalog: Catalog
    def database: Database
    def getTableName: ZIO[Any, Nothing, TableName] = ZIO.succeed(tableName)
    def getCatalog: ZIO[Any, Nothing, Catalog] = ZIO.succeed(catalog)
    def getDatabase: ZIO[Any, Nothing, Database] = ZIO.succeed(database)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCatalogConfig
  ) extends zio.aws.sagemaker.model.DataCatalogConfig.ReadOnly {
    override val tableName: TableName =
      zio.aws.sagemaker.model.primitives.TableName(impl.tableName())
    override val catalog: Catalog =
      zio.aws.sagemaker.model.primitives.Catalog(impl.catalog())
    override val database: Database =
      zio.aws.sagemaker.model.primitives.Database(impl.database())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataCatalogConfig
  ): zio.aws.sagemaker.model.DataCatalogConfig.ReadOnly = new Wrapper(impl)
}
