package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ContentType
import scala.jdk.CollectionConverters.*
final case class TransformInput(
    dataSource: zio.aws.sagemaker.model.TransformDataSource,
    contentType: Optional[ContentType] = Optional.Absent,
    compressionType: Optional[zio.aws.sagemaker.model.CompressionType] =
      Optional.Absent,
    splitType: Optional[zio.aws.sagemaker.model.SplitType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformInput = {
    import TransformInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformInput
      .builder()
      .dataSource(dataSource.buildAwsValue())
      .optionallyWith(
        contentType.map(value => ContentType.unwrap(value): java.lang.String)
      )(_.contentType)
      .optionallyWith(compressionType.map(value => value.unwrap))(
        _.compressionType
      )
      .optionallyWith(splitType.map(value => value.unwrap))(_.splitType)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformInput.ReadOnly =
    zio.aws.sagemaker.model.TransformInput.wrap(buildAwsValue())
}
object TransformInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformInput =
      zio.aws.sagemaker.model.TransformInput(
        dataSource.asEditable,
        contentType.map(value => value),
        compressionType.map(value => value),
        splitType.map(value => value)
      )
    def dataSource: zio.aws.sagemaker.model.TransformDataSource.ReadOnly
    def contentType: Optional[ContentType]
    def compressionType: Optional[zio.aws.sagemaker.model.CompressionType]
    def splitType: Optional[zio.aws.sagemaker.model.SplitType]
    def getDataSource: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.TransformDataSource.ReadOnly
    ] = ZIO.succeed(dataSource)
    def getContentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getCompressionType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.CompressionType] =
      AwsError.unwrapOptionField("compressionType", compressionType)
    def getSplitType: ZIO[Any, AwsError, zio.aws.sagemaker.model.SplitType] =
      AwsError.unwrapOptionField("splitType", splitType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformInput
  ) extends zio.aws.sagemaker.model.TransformInput.ReadOnly {
    override val dataSource
        : zio.aws.sagemaker.model.TransformDataSource.ReadOnly =
      zio.aws.sagemaker.model.TransformDataSource.wrap(impl.dataSource())
    override val contentType: Optional[ContentType] = zio.aws.core.internal
      .optionalFromNullable(impl.contentType())
      .map(value => zio.aws.sagemaker.model.primitives.ContentType(value))
    override val compressionType
        : Optional[zio.aws.sagemaker.model.CompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compressionType())
        .map(value => zio.aws.sagemaker.model.CompressionType.wrap(value))
    override val splitType: Optional[zio.aws.sagemaker.model.SplitType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.splitType())
        .map(value => zio.aws.sagemaker.model.SplitType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformInput
  ): zio.aws.sagemaker.model.TransformInput.ReadOnly = new Wrapper(impl)
}
