package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class TrainingJobStatusCounters(
    completed: Optional[TrainingJobStatusCounter] = Optional.Absent,
    inProgress: Optional[TrainingJobStatusCounter] = Optional.Absent,
    retryableError: Optional[TrainingJobStatusCounter] = Optional.Absent,
    nonRetryableError: Optional[TrainingJobStatusCounter] = Optional.Absent,
    stopped: Optional[TrainingJobStatusCounter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters = {
    import TrainingJobStatusCounters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
      .builder()
      .optionallyWith(
        completed.map(value => TrainingJobStatusCounter.unwrap(value): Integer)
      )(_.completed)
      .optionallyWith(
        inProgress.map(value => TrainingJobStatusCounter.unwrap(value): Integer)
      )(_.inProgress)
      .optionallyWith(
        retryableError.map(value =>
          TrainingJobStatusCounter.unwrap(value): Integer
        )
      )(_.retryableError)
      .optionallyWith(
        nonRetryableError.map(value =>
          TrainingJobStatusCounter.unwrap(value): Integer
        )
      )(_.nonRetryableError)
      .optionallyWith(
        stopped.map(value => TrainingJobStatusCounter.unwrap(value): Integer)
      )(_.stopped)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly =
    zio.aws.sagemaker.model.TrainingJobStatusCounters.wrap(buildAwsValue())
}
object TrainingJobStatusCounters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingJobStatusCounters =
      zio.aws.sagemaker.model.TrainingJobStatusCounters(
        completed.map(value => value),
        inProgress.map(value => value),
        retryableError.map(value => value),
        nonRetryableError.map(value => value),
        stopped.map(value => value)
      )
    def completed: Optional[TrainingJobStatusCounter]
    def inProgress: Optional[TrainingJobStatusCounter]
    def retryableError: Optional[TrainingJobStatusCounter]
    def nonRetryableError: Optional[TrainingJobStatusCounter]
    def stopped: Optional[TrainingJobStatusCounter]
    def getCompleted: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("completed", completed)
    def getInProgress: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("inProgress", inProgress)
    def getRetryableError: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("retryableError", retryableError)
    def getNonRetryableError: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("nonRetryableError", nonRetryableError)
    def getStopped: ZIO[Any, AwsError, TrainingJobStatusCounter] =
      AwsError.unwrapOptionField("stopped", stopped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
  ) extends zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly {
    override val completed: Optional[TrainingJobStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completed())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
        )
    override val inProgress: Optional[TrainingJobStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inProgress())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
        )
    override val retryableError: Optional[TrainingJobStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryableError())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
        )
    override val nonRetryableError: Optional[TrainingJobStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonRetryableError())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
        )
    override val stopped: Optional[TrainingJobStatusCounter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stopped())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingJobStatusCounter(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters
  ): zio.aws.sagemaker.model.TrainingJobStatusCounters.ReadOnly = new Wrapper(
    impl
  )
}
