package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.{SecretArn, Branch, GitConfigUrl}
import scala.jdk.CollectionConverters.*
final case class GitConfig(
    repositoryUrl: GitConfigUrl,
    branch: Optional[Branch] = Optional.Absent,
    secretArn: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GitConfig = {
    import GitConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GitConfig
      .builder()
      .repositoryUrl(GitConfigUrl.unwrap(repositoryUrl): java.lang.String)
      .optionallyWith(
        branch.map(value => Branch.unwrap(value): java.lang.String)
      )(_.branch)
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.GitConfig.ReadOnly =
    zio.aws.sagemaker.model.GitConfig.wrap(buildAwsValue())
}
object GitConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GitConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GitConfig =
      zio.aws.sagemaker.model.GitConfig(
        repositoryUrl,
        branch.map(value => value),
        secretArn.map(value => value)
      )
    def repositoryUrl: GitConfigUrl
    def branch: Optional[Branch]
    def secretArn: Optional[SecretArn]
    def getRepositoryUrl: ZIO[Any, Nothing, GitConfigUrl] =
      ZIO.succeed(repositoryUrl)
    def getBranch: ZIO[Any, AwsError, Branch] =
      AwsError.unwrapOptionField("branch", branch)
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GitConfig
  ) extends zio.aws.sagemaker.model.GitConfig.ReadOnly {
    override val repositoryUrl: GitConfigUrl =
      zio.aws.sagemaker.model.primitives.GitConfigUrl(impl.repositoryUrl())
    override val branch: Optional[Branch] = zio.aws.core.internal
      .optionalFromNullable(impl.branch())
      .map(value => zio.aws.sagemaker.model.primitives.Branch(value))
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.sagemaker.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GitConfig
  ): zio.aws.sagemaker.model.GitConfig.ReadOnly = new Wrapper(impl)
}
