package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.S3Uri
import scala.jdk.CollectionConverters.*
final case class TransformS3DataSource(
    s3DataType: zio.aws.sagemaker.model.S3DataType,
    s3Uri: S3Uri
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource = {
    import TransformS3DataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource
      .builder()
      .s3DataType(s3DataType.unwrap)
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformS3DataSource.ReadOnly =
    zio.aws.sagemaker.model.TransformS3DataSource.wrap(buildAwsValue())
}
object TransformS3DataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformS3DataSource =
      zio.aws.sagemaker.model.TransformS3DataSource(s3DataType, s3Uri)
    def s3DataType: zio.aws.sagemaker.model.S3DataType
    def s3Uri: S3Uri
    def getS3DataType: ZIO[Any, Nothing, zio.aws.sagemaker.model.S3DataType] =
      ZIO.succeed(s3DataType)
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource
  ) extends zio.aws.sagemaker.model.TransformS3DataSource.ReadOnly {
    override val s3DataType: zio.aws.sagemaker.model.S3DataType =
      zio.aws.sagemaker.model.S3DataType.wrap(impl.s3DataType())
    override val s3Uri: S3Uri =
      zio.aws.sagemaker.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformS3DataSource
  ): zio.aws.sagemaker.model.TransformS3DataSource.ReadOnly = new Wrapper(impl)
}
