package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  VolumeSizeInGB,
  TrainingInstanceCount
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ResourceConfig(
    instanceType: zio.aws.sagemaker.model.TrainingInstanceType,
    instanceCount: TrainingInstanceCount,
    volumeSizeInGB: VolumeSizeInGB,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ResourceConfig = {
    import ResourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ResourceConfig
      .builder()
      .instanceType(instanceType.unwrap)
      .instanceCount(TrainingInstanceCount.unwrap(instanceCount): Integer)
      .volumeSizeInGB(VolumeSizeInGB.unwrap(volumeSizeInGB): Integer)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ResourceConfig.ReadOnly =
    zio.aws.sagemaker.model.ResourceConfig.wrap(buildAwsValue())
}
object ResourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ResourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ResourceConfig =
      zio.aws.sagemaker.model.ResourceConfig(
        instanceType,
        instanceCount,
        volumeSizeInGB,
        volumeKmsKeyId.map(value => value)
      )
    def instanceType: zio.aws.sagemaker.model.TrainingInstanceType
    def instanceCount: TrainingInstanceCount
    def volumeSizeInGB: VolumeSizeInGB
    def volumeKmsKeyId: Optional[KmsKeyId]
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingInstanceType] =
      ZIO.succeed(instanceType)
    def getInstanceCount: ZIO[Any, Nothing, TrainingInstanceCount] =
      ZIO.succeed(instanceCount)
    def getVolumeSizeInGB: ZIO[Any, Nothing, VolumeSizeInGB] =
      ZIO.succeed(volumeSizeInGB)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceConfig
  ) extends zio.aws.sagemaker.model.ResourceConfig.ReadOnly {
    override val instanceType: zio.aws.sagemaker.model.TrainingInstanceType =
      zio.aws.sagemaker.model.TrainingInstanceType.wrap(impl.instanceType())
    override val instanceCount: TrainingInstanceCount =
      zio.aws.sagemaker.model.primitives
        .TrainingInstanceCount(impl.instanceCount())
    override val volumeSizeInGB: VolumeSizeInGB =
      zio.aws.sagemaker.model.primitives.VolumeSizeInGB(impl.volumeSizeInGB())
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ResourceConfig
  ): zio.aws.sagemaker.model.ResourceConfig.ReadOnly = new Wrapper(impl)
}
