package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  VariantWeight,
  InitialTaskCount,
  ModelName,
  VariantName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ProductionVariant(
    variantName: VariantName,
    modelName: ModelName,
    initialInstanceCount: Optional[InitialTaskCount] = Optional.Absent,
    instanceType: Optional[
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = Optional.Absent,
    initialVariantWeight: Optional[VariantWeight] = Optional.Absent,
    acceleratorType: Optional[
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = Optional.Absent,
    coreDumpConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig
    ] = Optional.Absent,
    serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProductionVariant = {
    import ProductionVariant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProductionVariant
      .builder()
      .variantName(VariantName.unwrap(variantName): java.lang.String)
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        initialInstanceCount.map(value =>
          InitialTaskCount.unwrap(value): Integer
        )
      )(_.initialInstanceCount)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        initialVariantWeight.map(value =>
          VariantWeight.unwrap(value): java.lang.Float
        )
      )(_.initialVariantWeight)
      .optionallyWith(acceleratorType.map(value => value.unwrap))(
        _.acceleratorType
      )
      .optionallyWith(coreDumpConfig.map(value => value.buildAwsValue()))(
        _.coreDumpConfig
      )
      .optionallyWith(serverlessConfig.map(value => value.buildAwsValue()))(
        _.serverlessConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProductionVariant.ReadOnly =
    zio.aws.sagemaker.model.ProductionVariant.wrap(buildAwsValue())
}
object ProductionVariant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProductionVariant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProductionVariant =
      zio.aws.sagemaker.model.ProductionVariant(
        variantName,
        modelName,
        initialInstanceCount.map(value => value),
        instanceType.map(value => value),
        initialVariantWeight.map(value => value),
        acceleratorType.map(value => value),
        coreDumpConfig.map(value => value.asEditable),
        serverlessConfig.map(value => value.asEditable)
      )
    def variantName: VariantName
    def modelName: ModelName
    def initialInstanceCount: Optional[InitialTaskCount]
    def instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType]
    def initialVariantWeight: Optional[VariantWeight]
    def acceleratorType
        : Optional[zio.aws.sagemaker.model.ProductionVariantAcceleratorType]
    def coreDumpConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly
    ]
    def serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ]
    def getVariantName: ZIO[Any, Nothing, VariantName] =
      ZIO.succeed(variantName)
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
    def getInitialInstanceCount: ZIO[Any, AwsError, InitialTaskCount] =
      AwsError.unwrapOptionField("initialInstanceCount", initialInstanceCount)
    def getInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantInstanceType
    ] = AwsError.unwrapOptionField("instanceType", instanceType)
    def getInitialVariantWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("initialVariantWeight", initialVariantWeight)
    def getAcceleratorType: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantAcceleratorType
    ] = AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getCoreDumpConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly
    ] = AwsError.unwrapOptionField("coreDumpConfig", coreDumpConfig)
    def getServerlessConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = AwsError.unwrapOptionField("serverlessConfig", serverlessConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariant
  ) extends zio.aws.sagemaker.model.ProductionVariant.ReadOnly {
    override val variantName: VariantName =
      zio.aws.sagemaker.model.primitives.VariantName(impl.variantName())
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
    override val initialInstanceCount: Optional[InitialTaskCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialInstanceCount())
        .map(value =>
          zio.aws.sagemaker.model.primitives.InitialTaskCount(value)
        )
    override val instanceType
        : Optional[zio.aws.sagemaker.model.ProductionVariantInstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantInstanceType.wrap(value)
        )
    override val initialVariantWeight: Optional[VariantWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initialVariantWeight())
        .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val acceleratorType
        : Optional[zio.aws.sagemaker.model.ProductionVariantAcceleratorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorType())
        .map(value =>
          zio.aws.sagemaker.model.ProductionVariantAcceleratorType.wrap(value)
        )
    override val coreDumpConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.coreDumpConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantCoreDumpConfig.wrap(value)
      )
    override val serverlessConfig: Optional[
      zio.aws.sagemaker.model.ProductionVariantServerlessConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverlessConfig())
      .map(value =>
        zio.aws.sagemaker.model.ProductionVariantServerlessConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProductionVariant
  ): zio.aws.sagemaker.model.ProductionVariant.ReadOnly = new Wrapper(impl)
}
