package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  KmsKeyId,
  ProcessingVolumeSizeInGB,
  ProcessingInstanceCount
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ProcessingClusterConfig(
    instanceCount: ProcessingInstanceCount,
    instanceType: zio.aws.sagemaker.model.ProcessingInstanceType,
    volumeSizeInGB: ProcessingVolumeSizeInGB,
    volumeKmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ProcessingClusterConfig = {
    import ProcessingClusterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ProcessingClusterConfig
      .builder()
      .instanceCount(ProcessingInstanceCount.unwrap(instanceCount): Integer)
      .instanceType(instanceType.unwrap)
      .volumeSizeInGB(ProcessingVolumeSizeInGB.unwrap(volumeSizeInGB): Integer)
      .optionallyWith(
        volumeKmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.volumeKmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ProcessingClusterConfig.ReadOnly =
    zio.aws.sagemaker.model.ProcessingClusterConfig.wrap(buildAwsValue())
}
object ProcessingClusterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ProcessingClusterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ProcessingClusterConfig =
      zio.aws.sagemaker.model.ProcessingClusterConfig(
        instanceCount,
        instanceType,
        volumeSizeInGB,
        volumeKmsKeyId.map(value => value)
      )
    def instanceCount: ProcessingInstanceCount
    def instanceType: zio.aws.sagemaker.model.ProcessingInstanceType
    def volumeSizeInGB: ProcessingVolumeSizeInGB
    def volumeKmsKeyId: Optional[KmsKeyId]
    def getInstanceCount: ZIO[Any, Nothing, ProcessingInstanceCount] =
      ZIO.succeed(instanceCount)
    def getInstanceType
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ProcessingInstanceType] =
      ZIO.succeed(instanceType)
    def getVolumeSizeInGB: ZIO[Any, Nothing, ProcessingVolumeSizeInGB] =
      ZIO.succeed(volumeSizeInGB)
    def getVolumeKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("volumeKmsKeyId", volumeKmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingClusterConfig
  ) extends zio.aws.sagemaker.model.ProcessingClusterConfig.ReadOnly {
    override val instanceCount: ProcessingInstanceCount =
      zio.aws.sagemaker.model.primitives
        .ProcessingInstanceCount(impl.instanceCount())
    override val instanceType: zio.aws.sagemaker.model.ProcessingInstanceType =
      zio.aws.sagemaker.model.ProcessingInstanceType.wrap(impl.instanceType())
    override val volumeSizeInGB: ProcessingVolumeSizeInGB =
      zio.aws.sagemaker.model.primitives
        .ProcessingVolumeSizeInGB(impl.volumeSizeInGB())
    override val volumeKmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeKmsKeyId())
      .map(value => zio.aws.sagemaker.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ProcessingClusterConfig
  ): zio.aws.sagemaker.model.ProcessingClusterConfig.ReadOnly = new Wrapper(
    impl
  )
}
