package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ModelMetrics(
    modelQuality: Optional[zio.aws.sagemaker.model.ModelQuality] =
      Optional.Absent,
    modelDataQuality: Optional[zio.aws.sagemaker.model.ModelDataQuality] =
      Optional.Absent,
    bias: Optional[zio.aws.sagemaker.model.Bias] = Optional.Absent,
    explainability: Optional[zio.aws.sagemaker.model.Explainability] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelMetrics = {
    import ModelMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelMetrics
      .builder()
      .optionallyWith(modelQuality.map(value => value.buildAwsValue()))(
        _.modelQuality
      )
      .optionallyWith(modelDataQuality.map(value => value.buildAwsValue()))(
        _.modelDataQuality
      )
      .optionallyWith(bias.map(value => value.buildAwsValue()))(_.bias)
      .optionallyWith(explainability.map(value => value.buildAwsValue()))(
        _.explainability
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelMetrics.ReadOnly =
    zio.aws.sagemaker.model.ModelMetrics.wrap(buildAwsValue())
}
object ModelMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelMetrics =
      zio.aws.sagemaker.model.ModelMetrics(
        modelQuality.map(value => value.asEditable),
        modelDataQuality.map(value => value.asEditable),
        bias.map(value => value.asEditable),
        explainability.map(value => value.asEditable)
      )
    def modelQuality: Optional[zio.aws.sagemaker.model.ModelQuality.ReadOnly]
    def modelDataQuality
        : Optional[zio.aws.sagemaker.model.ModelDataQuality.ReadOnly]
    def bias: Optional[zio.aws.sagemaker.model.Bias.ReadOnly]
    def explainability
        : Optional[zio.aws.sagemaker.model.Explainability.ReadOnly]
    def getModelQuality
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ModelQuality.ReadOnly] =
      AwsError.unwrapOptionField("modelQuality", modelQuality)
    def getModelDataQuality: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ModelDataQuality.ReadOnly
    ] = AwsError.unwrapOptionField("modelDataQuality", modelDataQuality)
    def getBias: ZIO[Any, AwsError, zio.aws.sagemaker.model.Bias.ReadOnly] =
      AwsError.unwrapOptionField("bias", bias)
    def getExplainability
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.Explainability.ReadOnly] =
      AwsError.unwrapOptionField("explainability", explainability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetrics
  ) extends zio.aws.sagemaker.model.ModelMetrics.ReadOnly {
    override val modelQuality
        : Optional[zio.aws.sagemaker.model.ModelQuality.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelQuality())
        .map(value => zio.aws.sagemaker.model.ModelQuality.wrap(value))
    override val modelDataQuality
        : Optional[zio.aws.sagemaker.model.ModelDataQuality.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDataQuality())
        .map(value => zio.aws.sagemaker.model.ModelDataQuality.wrap(value))
    override val bias: Optional[zio.aws.sagemaker.model.Bias.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bias())
        .map(value => zio.aws.sagemaker.model.Bias.wrap(value))
    override val explainability
        : Optional[zio.aws.sagemaker.model.Explainability.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explainability())
        .map(value => zio.aws.sagemaker.model.Explainability.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelMetrics
  ): zio.aws.sagemaker.model.ModelMetrics.ReadOnly = new Wrapper(impl)
}
