package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelMetadataFilterType {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType
}
object ModelMetadataFilterType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType
  ): zio.aws.sagemaker.model.ModelMetadataFilterType = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.DOMAIN =>
      val r = Domain
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.FRAMEWORK =>
      val r = Framework
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.TASK =>
      val r = Task
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.FRAMEWORK_VERSION =>
      val r = FrameworkVersion
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelMetadataFilterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType =
      software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object Domain extends zio.aws.sagemaker.model.ModelMetadataFilterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType =
      software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.DOMAIN
  }
  case object Framework
      extends zio.aws.sagemaker.model.ModelMetadataFilterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType =
      software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.FRAMEWORK
  }
  case object Task extends zio.aws.sagemaker.model.ModelMetadataFilterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType =
      software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.TASK
  }
  case object FrameworkVersion
      extends zio.aws.sagemaker.model.ModelMetadataFilterType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType =
      software.amazon.awssdk.services.sagemaker.model.ModelMetadataFilterType.FRAMEWORK_VERSION
  }
}
