package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HyperParameterScalingType {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType
}
object HyperParameterScalingType {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType
  ): zio.aws.sagemaker.model.HyperParameterScalingType = value match {
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.AUTO =>
      val r = Auto
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.LINEAR =>
      val r = Linear
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.LOGARITHMIC =>
      val r = Logarithmic
      r
    case software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.REVERSE_LOGARITHMIC =>
      val r = ReverseLogarithmic
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HyperParameterScalingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.UNKNOWN_TO_SDK_VERSION
  }
  case object Auto extends zio.aws.sagemaker.model.HyperParameterScalingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.AUTO
  }
  case object Linear extends zio.aws.sagemaker.model.HyperParameterScalingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.LINEAR
  }
  case object Logarithmic
      extends zio.aws.sagemaker.model.HyperParameterScalingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.LOGARITHMIC
  }
  case object ReverseLogarithmic
      extends zio.aws.sagemaker.model.HyperParameterScalingType {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType =
      software.amazon.awssdk.services.sagemaker.model.HyperParameterScalingType.REVERSE_LOGARITHMIC
  }
}
