package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait HumanTaskUiStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus
}
object HumanTaskUiStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus
  ): zio.aws.sagemaker.model.HumanTaskUiStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus.ACTIVE =>
      val r = Active
      r
    case software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.HumanTaskUiStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus =
      software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Active extends zio.aws.sagemaker.model.HumanTaskUiStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus =
      software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus.ACTIVE
  }
  case object Deleting extends zio.aws.sagemaker.model.HumanTaskUiStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus =
      software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus.DELETING
  }
}
