package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait DetailedAlgorithmStatus {
  def unwrap
      : software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus
}
object DetailedAlgorithmStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus
  ): zio.aws.sagemaker.model.DetailedAlgorithmStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.NOT_STARTED =>
      val r = NotStarted
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.DetailedAlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NotStarted
      extends zio.aws.sagemaker.model.DetailedAlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.NOT_STARTED
  }
  case object InProgress
      extends zio.aws.sagemaker.model.DetailedAlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.IN_PROGRESS
  }
  case object Completed
      extends zio.aws.sagemaker.model.DetailedAlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.COMPLETED
  }
  case object Failed extends zio.aws.sagemaker.model.DetailedAlgorithmStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus =
      software.amazon.awssdk.services.sagemaker.model.DetailedAlgorithmStatus.FAILED
  }
}
