package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.FlowDefinitionName
import scala.jdk.CollectionConverters.*
final case class DescribeFlowDefinitionRequest(
    flowDefinitionName: FlowDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest = {
    import DescribeFlowDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest
      .builder()
      .flowDefinitionName(
        FlowDefinitionName.unwrap(flowDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeFlowDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeFlowDefinitionRequest.wrap(buildAwsValue())
}
object DescribeFlowDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeFlowDefinitionRequest =
      zio.aws.sagemaker.model.DescribeFlowDefinitionRequest(flowDefinitionName)
    def flowDefinitionName: FlowDefinitionName
    def getFlowDefinitionName: ZIO[Any, Nothing, FlowDefinitionName] =
      ZIO.succeed(flowDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest
  ) extends zio.aws.sagemaker.model.DescribeFlowDefinitionRequest.ReadOnly {
    override val flowDefinitionName: FlowDefinitionName =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionName(impl.flowDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeFlowDefinitionRequest
  ): zio.aws.sagemaker.model.DescribeFlowDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
