package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.ExperimentArn
import scala.jdk.CollectionConverters.*
final case class DeleteExperimentResponse(
    experimentArn: Optional[ExperimentArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse = {
    import DeleteExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse
      .builder()
      .optionallyWith(
        experimentArn.map(value =>
          ExperimentArn.unwrap(value): java.lang.String
        )
      )(_.experimentArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly =
    zio.aws.sagemaker.model.DeleteExperimentResponse.wrap(buildAwsValue())
}
object DeleteExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteExperimentResponse =
      zio.aws.sagemaker.model
        .DeleteExperimentResponse(experimentArn.map(value => value))
    def experimentArn: Optional[ExperimentArn]
    def getExperimentArn: ZIO[Any, AwsError, ExperimentArn] =
      AwsError.unwrapOptionField("experimentArn", experimentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse
  ) extends zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly {
    override val experimentArn: Optional[ExperimentArn] = zio.aws.core.internal
      .optionalFromNullable(impl.experimentArn())
      .map(value => zio.aws.sagemaker.model.primitives.ExperimentArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteExperimentResponse
  ): zio.aws.sagemaker.model.DeleteExperimentResponse.ReadOnly = new Wrapper(
    impl
  )
}
