package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DataQualityJobInput(
    endpointInput: zio.aws.sagemaker.model.EndpointInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput = {
    import DataQualityJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput
      .builder()
      .endpointInput(endpointInput.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly =
    zio.aws.sagemaker.model.DataQualityJobInput.wrap(buildAwsValue())
}
object DataQualityJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DataQualityJobInput =
      zio.aws.sagemaker.model.DataQualityJobInput(endpointInput.asEditable)
    def endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly
    def getEndpointInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      ZIO.succeed(endpointInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput
  ) extends zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly {
    override val endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly =
      zio.aws.sagemaker.model.EndpointInput.wrap(impl.endpointInput())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DataQualityJobInput
  ): zio.aws.sagemaker.model.DataQualityJobInput.ReadOnly = new Wrapper(impl)
}
