package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.RoleArn
import scala.jdk.CollectionConverters.*
final case class AlgorithmValidationSpecification(
    validationRole: RoleArn,
    validationProfiles: Iterable[
      zio.aws.sagemaker.model.AlgorithmValidationProfile
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification = {
    import AlgorithmValidationSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification
      .builder()
      .validationRole(RoleArn.unwrap(validationRole): java.lang.String)
      .validationProfiles(validationProfiles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly =
    zio.aws.sagemaker.model.AlgorithmValidationSpecification
      .wrap(buildAwsValue())
}
object AlgorithmValidationSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.AlgorithmValidationSpecification =
      zio.aws.sagemaker.model.AlgorithmValidationSpecification(
        validationRole,
        validationProfiles.map { item =>
          item.asEditable
        }
      )
    def validationRole: RoleArn
    def validationProfiles
        : List[zio.aws.sagemaker.model.AlgorithmValidationProfile.ReadOnly]
    def getValidationRole: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(validationRole)
    def getValidationProfiles: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.AlgorithmValidationProfile.ReadOnly
    ]] = ZIO.succeed(validationProfiles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification
  ) extends zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly {
    override val validationRole: RoleArn =
      zio.aws.sagemaker.model.primitives.RoleArn(impl.validationRole())
    override val validationProfiles
        : List[zio.aws.sagemaker.model.AlgorithmValidationProfile.ReadOnly] =
      impl
        .validationProfiles()
        .asScala
        .map { item =>
          zio.aws.sagemaker.model.AlgorithmValidationProfile.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.AlgorithmValidationSpecification
  ): zio.aws.sagemaker.model.AlgorithmValidationSpecification.ReadOnly =
    new Wrapper(impl)
}
