package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ModelExplainabilityJobInput(
    endpointInput: zio.aws.sagemaker.model.EndpointInput
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityJobInput = {
    import ModelExplainabilityJobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityJobInput
      .builder()
      .endpointInput(endpointInput.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly =
    zio.aws.sagemaker.model.ModelExplainabilityJobInput.wrap(buildAwsValue())
}
object ModelExplainabilityJobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityJobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ModelExplainabilityJobInput =
      zio.aws.sagemaker.model
        .ModelExplainabilityJobInput(endpointInput.asEditable)
    def endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly
    def getEndpointInput
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.EndpointInput.ReadOnly] =
      ZIO.succeed(endpointInput)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityJobInput
  ) extends zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly {
    override val endpointInput: zio.aws.sagemaker.model.EndpointInput.ReadOnly =
      zio.aws.sagemaker.model.EndpointInput.wrap(impl.endpointInput())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ModelExplainabilityJobInput
  ): zio.aws.sagemaker.model.ModelExplainabilityJobInput.ReadOnly = new Wrapper(
    impl
  )
}
