package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MetricDatum(
    metricName: Optional[zio.aws.sagemaker.model.AutoMLMetricEnum] =
      Optional.Absent,
    value: Optional[Float] = Optional.Absent,
    set: Optional[zio.aws.sagemaker.model.MetricSetSource] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetricDatum = {
    import MetricDatum.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetricDatum
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(value.map(value => value: java.lang.Float))(_.value)
      .optionallyWith(set.map(value => value.unwrap))(_.set)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetricDatum.ReadOnly =
    zio.aws.sagemaker.model.MetricDatum.wrap(buildAwsValue())
}
object MetricDatum {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetricDatum
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetricDatum =
      zio.aws.sagemaker.model.MetricDatum(
        metricName.map(value => value),
        value.map(value => value),
        set.map(value => value)
      )
    def metricName: Optional[zio.aws.sagemaker.model.AutoMLMetricEnum]
    def value: Optional[Float]
    def set: Optional[zio.aws.sagemaker.model.MetricSetSource]
    def getMetricName
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.AutoMLMetricEnum] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getValue: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("value", value)
    def getSet: ZIO[Any, AwsError, zio.aws.sagemaker.model.MetricSetSource] =
      AwsError.unwrapOptionField("set", set)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricDatum
  ) extends zio.aws.sagemaker.model.MetricDatum.ReadOnly {
    override val metricName
        : Optional[zio.aws.sagemaker.model.AutoMLMetricEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value => zio.aws.sagemaker.model.AutoMLMetricEnum.wrap(value))
    override val value: Optional[Float] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Float)
    override val set: Optional[zio.aws.sagemaker.model.MetricSetSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.set())
        .map(value => zio.aws.sagemaker.model.MetricSetSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetricDatum
  ): zio.aws.sagemaker.model.MetricDatum.ReadOnly = new Wrapper(impl)
}
