package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.sagemaker.model.primitives.SecretArn
import scala.jdk.CollectionConverters.*
final case class GitConfigForUpdate(
    secretArn: Optional[SecretArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.GitConfigForUpdate = {
    import GitConfigForUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.GitConfigForUpdate
      .builder()
      .optionallyWith(
        secretArn.map(value => SecretArn.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.GitConfigForUpdate.ReadOnly =
    zio.aws.sagemaker.model.GitConfigForUpdate.wrap(buildAwsValue())
}
object GitConfigForUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.GitConfigForUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.GitConfigForUpdate =
      zio.aws.sagemaker.model.GitConfigForUpdate(secretArn.map(value => value))
    def secretArn: Optional[SecretArn]
    def getSecretArn: ZIO[Any, AwsError, SecretArn] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.GitConfigForUpdate
  ) extends zio.aws.sagemaker.model.GitConfigForUpdate.ReadOnly {
    override val secretArn: Optional[SecretArn] = zio.aws.core.internal
      .optionalFromNullable(impl.secretArn())
      .map(value => zio.aws.sagemaker.model.primitives.SecretArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.GitConfigForUpdate
  ): zio.aws.sagemaker.model.GitConfigForUpdate.ReadOnly = new Wrapper(impl)
}
