package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TaskCount,
  VariantWeight,
  VariantName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DesiredWeightAndCapacity(
    variantName: VariantName,
    desiredWeight: Optional[VariantWeight] = Optional.Absent,
    desiredInstanceCount: Optional[TaskCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity = {
    import DesiredWeightAndCapacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity
      .builder()
      .variantName(VariantName.unwrap(variantName): java.lang.String)
      .optionallyWith(
        desiredWeight.map(value => VariantWeight.unwrap(value): java.lang.Float)
      )(_.desiredWeight)
      .optionallyWith(
        desiredInstanceCount.map(value => TaskCount.unwrap(value): Integer)
      )(_.desiredInstanceCount)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DesiredWeightAndCapacity.ReadOnly =
    zio.aws.sagemaker.model.DesiredWeightAndCapacity.wrap(buildAwsValue())
}
object DesiredWeightAndCapacity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DesiredWeightAndCapacity =
      zio.aws.sagemaker.model.DesiredWeightAndCapacity(
        variantName,
        desiredWeight.map(value => value),
        desiredInstanceCount.map(value => value)
      )
    def variantName: VariantName
    def desiredWeight: Optional[VariantWeight]
    def desiredInstanceCount: Optional[TaskCount]
    def getVariantName: ZIO[Any, Nothing, VariantName] =
      ZIO.succeed(variantName)
    def getDesiredWeight: ZIO[Any, AwsError, VariantWeight] =
      AwsError.unwrapOptionField("desiredWeight", desiredWeight)
    def getDesiredInstanceCount: ZIO[Any, AwsError, TaskCount] =
      AwsError.unwrapOptionField("desiredInstanceCount", desiredInstanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity
  ) extends zio.aws.sagemaker.model.DesiredWeightAndCapacity.ReadOnly {
    override val variantName: VariantName =
      zio.aws.sagemaker.model.primitives.VariantName(impl.variantName())
    override val desiredWeight: Optional[VariantWeight] = zio.aws.core.internal
      .optionalFromNullable(impl.desiredWeight())
      .map(value => zio.aws.sagemaker.model.primitives.VariantWeight(value))
    override val desiredInstanceCount: Optional[TaskCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredInstanceCount())
        .map(value => zio.aws.sagemaker.model.primitives.TaskCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DesiredWeightAndCapacity
  ): zio.aws.sagemaker.model.DesiredWeightAndCapacity.ReadOnly = new Wrapper(
    impl
  )
}
