package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ModelName
import scala.jdk.CollectionConverters.*
final case class DescribeModelRequest(modelName: ModelName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest = {
    import DescribeModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest
      .builder()
      .modelName(ModelName.unwrap(modelName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeModelRequest.ReadOnly =
    zio.aws.sagemaker.model.DescribeModelRequest.wrap(buildAwsValue())
}
object DescribeModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeModelRequest =
      zio.aws.sagemaker.model.DescribeModelRequest(modelName)
    def modelName: ModelName
    def getModelName: ZIO[Any, Nothing, ModelName] = ZIO.succeed(modelName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest
  ) extends zio.aws.sagemaker.model.DescribeModelRequest.ReadOnly {
    override val modelName: ModelName =
      zio.aws.sagemaker.model.primitives.ModelName(impl.modelName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeModelRequest
  ): zio.aws.sagemaker.model.DescribeModelRequest.ReadOnly = new Wrapper(impl)
}
