package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.{SubnetId, SecurityGroupId}
import scala.jdk.CollectionConverters.*
final case class VpcConfig(
    securityGroupIds: Iterable[SecurityGroupId],
    subnets: Iterable[SubnetId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.VpcConfig = {
    import VpcConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.VpcConfig
      .builder()
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .subnets(subnets.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.VpcConfig.ReadOnly =
    zio.aws.sagemaker.model.VpcConfig.wrap(buildAwsValue())
}
object VpcConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.VpcConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.VpcConfig =
      zio.aws.sagemaker.model.VpcConfig(securityGroupIds, subnets)
    def securityGroupIds: List[SecurityGroupId]
    def subnets: List[SubnetId]
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
    def getSubnets: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.VpcConfig
  ) extends zio.aws.sagemaker.model.VpcConfig.ReadOnly {
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.SecurityGroupId(item)
      }
      .toList
    override val subnets: List[SubnetId] = impl
      .subnets()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.SubnetId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.VpcConfig
  ): zio.aws.sagemaker.model.VpcConfig.ReadOnly = new Wrapper(impl)
}
