package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait TargetDevice {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.TargetDevice
}
object TargetDevice {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.TargetDevice
  ): zio.aws.sagemaker.model.TargetDevice = value match {
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.LAMBDA =>
      val r = lambda
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_M4 =>
      val r = ml_m4
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_M5 =>
      val r = ml_m5
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_C4 =>
      val r = ml_c4
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_C5 =>
      val r = ml_c5
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_P2 =>
      val r = ml_p2
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_P3 =>
      val r = ml_p3
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_G4_DN =>
      val r = ml_g4dn
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_INF1 =>
      val r = ml_inf1
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_EIA2 =>
      val r = ml_eia2
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_TX1 =>
      val r = jetson_tx1
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_TX2 =>
      val r = jetson_tx2
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_NANO =>
      val r = jetson_nano
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_XAVIER =>
      val r = jetson_xavier
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.RASP3_B =>
      val r = rasp3b
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.IMX8_QM =>
      val r = imx8qm
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.DEEPLENS =>
      val r = deeplens
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.RK3399 =>
      val r = rk3399
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.RK3288 =>
      val r = rk3288
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.AISAGE =>
      val r = aisage
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.SBE_C =>
      val r = sbe_c
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.QCS605 =>
      val r = qcs605
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.QCS603 =>
      val r = qcs603
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.SITARA_AM57_X =>
      val r = sitara_am57x
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.AMBA_CV2 =>
      val r = amba_cv2
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.AMBA_CV22 =>
      val r = amba_cv22
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.AMBA_CV25 =>
      val r = amba_cv25
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.X86_WIN32 =>
      val r = x86_win32
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.X86_WIN64 =>
      val r = x86_win64
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.COREML =>
      val r = coreml
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.JACINTO_TDA4_VM =>
      val r = jacinto_tda4vm
      r
    case software.amazon.awssdk.services.sagemaker.model.TargetDevice.IMX8_MPLUS =>
      val r = imx8mplus
      r
  }
  case object unknownToSdkVersion extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.UNKNOWN_TO_SDK_VERSION
  }
  case object lambda extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.LAMBDA
  }
  case object ml_m4 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_M4
  }
  case object ml_m5 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_M5
  }
  case object ml_c4 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_C4
  }
  case object ml_c5 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_C5
  }
  case object ml_p2 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_P2
  }
  case object ml_p3 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_P3
  }
  case object ml_g4dn extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_G4_DN
  }
  case object ml_inf1 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_INF1
  }
  case object ml_eia2 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.ML_EIA2
  }
  case object jetson_tx1 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_TX1
  }
  case object jetson_tx2 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_TX2
  }
  case object jetson_nano extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_NANO
  }
  case object jetson_xavier extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.JETSON_XAVIER
  }
  case object rasp3b extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.RASP3_B
  }
  case object imx8qm extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.IMX8_QM
  }
  case object deeplens extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.DEEPLENS
  }
  case object rk3399 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.RK3399
  }
  case object rk3288 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.RK3288
  }
  case object aisage extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.AISAGE
  }
  case object sbe_c extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.SBE_C
  }
  case object qcs605 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.QCS605
  }
  case object qcs603 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.QCS603
  }
  case object sitara_am57x extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.SITARA_AM57_X
  }
  case object amba_cv2 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.AMBA_CV2
  }
  case object amba_cv22 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.AMBA_CV22
  }
  case object amba_cv25 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.AMBA_CV25
  }
  case object x86_win32 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.X86_WIN32
  }
  case object x86_win64 extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.X86_WIN64
  }
  case object coreml extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.COREML
  }
  case object jacinto_tda4vm extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.JACINTO_TDA4_VM
  }
  case object imx8mplus extends zio.aws.sagemaker.model.TargetDevice {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.TargetDevice =
      software.amazon.awssdk.services.sagemaker.model.TargetDevice.IMX8_MPLUS
  }
}
