package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait RStudioServerProAccessStatus {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus
}
object RStudioServerProAccessStatus {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus
  ): zio.aws.sagemaker.model.RStudioServerProAccessStatus = value match {
    case software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.RStudioServerProAccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus =
      software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED
      extends zio.aws.sagemaker.model.RStudioServerProAccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus =
      software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus.ENABLED
  }
  case object DISABLED
      extends zio.aws.sagemaker.model.RStudioServerProAccessStatus {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus =
      software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus.DISABLED
  }
}
