package zio.aws.sagemaker.model
import scala.jdk.CollectionConverters.*
sealed trait ModelCacheSetting {
  def unwrap: software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting
}
object ModelCacheSetting {
  def wrap(
      value: software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting
  ): zio.aws.sagemaker.model.ModelCacheSetting = value match {
    case software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting.DISABLED =>
      val r = Disabled
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sagemaker.model.ModelCacheSetting {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting =
      software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled extends zio.aws.sagemaker.model.ModelCacheSetting {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting =
      software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting.ENABLED
  }
  case object Disabled extends zio.aws.sagemaker.model.ModelCacheSetting {
    override def unwrap
        : software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting =
      software.amazon.awssdk.services.sagemaker.model.ModelCacheSetting.DISABLED
  }
}
