package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListFeatureGroupsResponse(
    featureGroupSummaries: Iterable[
      zio.aws.sagemaker.model.FeatureGroupSummary
    ],
    nextToken: NextToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse = {
    import ListFeatureGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse
      .builder()
      .featureGroupSummaries(featureGroupSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListFeatureGroupsResponse.wrap(buildAwsValue())
}
object ListFeatureGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListFeatureGroupsResponse =
      zio.aws.sagemaker.model.ListFeatureGroupsResponse(
        featureGroupSummaries.map { item =>
          item.asEditable
        },
        nextToken
      )
    def featureGroupSummaries
        : List[zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly]
    def nextToken: NextToken
    def getFeatureGroupSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly
    ]] = ZIO.succeed(featureGroupSummaries)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse
  ) extends zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly {
    override val featureGroupSummaries
        : List[zio.aws.sagemaker.model.FeatureGroupSummary.ReadOnly] = impl
      .featureGroupSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.FeatureGroupSummary.wrap(item)
      }
      .toList
    override val nextToken: NextToken =
      zio.aws.sagemaker.model.primitives.NextToken(impl.nextToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListFeatureGroupsResponse
  ): zio.aws.sagemaker.model.ListFeatureGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
