package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  ExperimentEntityName,
  TrialComponentKey64,
  TrialComponentArn,
  Timestamp,
  LineageGroupArn,
  TrialComponentKey256
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeTrialComponentResponse(
    trialComponentName: Optional[ExperimentEntityName] = Optional.Absent,
    trialComponentArn: Optional[TrialComponentArn] = Optional.Absent,
    displayName: Optional[ExperimentEntityName] = Optional.Absent,
    source: Optional[zio.aws.sagemaker.model.TrialComponentSource] =
      Optional.Absent,
    status: Optional[zio.aws.sagemaker.model.TrialComponentStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[zio.aws.sagemaker.model.UserContext] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext] =
      Optional.Absent,
    parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue
    ]] = Optional.Absent,
    inputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    outputArtifacts: Optional[
      Map[TrialComponentKey64, zio.aws.sagemaker.model.TrialComponentArtifact]
    ] = Optional.Absent,
    metadataProperties: Optional[zio.aws.sagemaker.model.MetadataProperties] =
      Optional.Absent,
    metrics: Optional[
      Iterable[zio.aws.sagemaker.model.TrialComponentMetricSummary]
    ] = Optional.Absent,
    lineageGroupArn: Optional[LineageGroupArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse = {
    import DescribeTrialComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse
      .builder()
      .optionallyWith(
        trialComponentName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.trialComponentName)
      .optionallyWith(
        trialComponentArn.map(value =>
          TrialComponentArn.unwrap(value): java.lang.String
        )
      )(_.trialComponentArn)
      .optionallyWith(
        displayName.map(value =>
          ExperimentEntityName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(lastModifiedBy.map(value => value.buildAwsValue()))(
        _.lastModifiedBy
      )
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey256.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        inputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.inputArtifacts)
      .optionallyWith(
        outputArtifacts.map(value =>
          value
            .map({ case (key, value) =>
              (TrialComponentKey64.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.outputArtifacts)
      .optionallyWith(metadataProperties.map(value => value.buildAwsValue()))(
        _.metadataProperties
      )
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        lineageGroupArn.map(value =>
          LineageGroupArn.unwrap(value): java.lang.String
        )
      )(_.lineageGroupArn)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeTrialComponentResponse.wrap(buildAwsValue())
}
object DescribeTrialComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTrialComponentResponse =
      zio.aws.sagemaker.model.DescribeTrialComponentResponse(
        trialComponentName.map(value => value),
        trialComponentArn.map(value => value),
        displayName.map(value => value),
        source.map(value => value.asEditable),
        status.map(value => value.asEditable),
        startTime.map(value => value),
        endTime.map(value => value),
        creationTime.map(value => value),
        createdBy.map(value => value.asEditable),
        lastModifiedTime.map(value => value),
        lastModifiedBy.map(value => value.asEditable),
        parameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        inputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        outputArtifacts.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        metadataProperties.map(value => value.asEditable),
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lineageGroupArn.map(value => value)
      )
    def trialComponentName: Optional[ExperimentEntityName]
    def trialComponentArn: Optional[TrialComponentArn]
    def displayName: Optional[ExperimentEntityName]
    def source: Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly]
    def status: Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly]
    def startTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def creationTime: Optional[Timestamp]
    def createdBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def lastModifiedTime: Optional[Timestamp]
    def lastModifiedBy: Optional[zio.aws.sagemaker.model.UserContext.ReadOnly]
    def parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]]
    def inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]]
    def metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly]
    def metrics: Optional[
      List[zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly]
    ]
    def lineageGroupArn: Optional[LineageGroupArn]
    def getTrialComponentName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("trialComponentName", trialComponentName)
    def getTrialComponentArn: ZIO[Any, AwsError, TrialComponentArn] =
      AwsError.unwrapOptionField("trialComponentArn", trialComponentArn)
    def getDisplayName: ZIO[Any, AwsError, ExperimentEntityName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentSource.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCreatedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getLastModifiedBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.UserContext.ReadOnly] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getParameters: ZIO[Any, AwsError, Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getInputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getOutputArtifacts: ZIO[Any, AwsError, Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getMetadataProperties: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.MetadataProperties.ReadOnly
    ] = AwsError.unwrapOptionField("metadataProperties", metadataProperties)
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getLineageGroupArn: ZIO[Any, AwsError, LineageGroupArn] =
      AwsError.unwrapOptionField("lineageGroupArn", lineageGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse
  ) extends zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly {
    override val trialComponentName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val trialComponentArn: Optional[TrialComponentArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trialComponentArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrialComponentArn(value)
        )
    override val displayName: Optional[ExperimentEntityName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.sagemaker.model.primitives.ExperimentEntityName(value)
        )
    override val source
        : Optional[zio.aws.sagemaker.model.TrialComponentSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sagemaker.model.TrialComponentSource.wrap(value))
    override val status
        : Optional[zio.aws.sagemaker.model.TrialComponentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sagemaker.model.TrialComponentStatus.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedBy
        : Optional[zio.aws.sagemaker.model.UserContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.sagemaker.model.UserContext.wrap(value))
    override val parameters: Optional[Map[
      TrialComponentKey256,
      zio.aws.sagemaker.model.TrialComponentParameterValue.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey256(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentParameterValue
              .wrap(value)
          })
          .toMap
      )
    override val inputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.inputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val outputArtifacts: Optional[Map[
      TrialComponentKey64,
      zio.aws.sagemaker.model.TrialComponentArtifact.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.outputArtifacts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.sagemaker.model.primitives.TrialComponentKey64(
              key
            ) -> zio.aws.sagemaker.model.TrialComponentArtifact.wrap(value)
          })
          .toMap
      )
    override val metadataProperties
        : Optional[zio.aws.sagemaker.model.MetadataProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadataProperties())
        .map(value => zio.aws.sagemaker.model.MetadataProperties.wrap(value))
    override val metrics: Optional[
      List[zio.aws.sagemaker.model.TrialComponentMetricSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.TrialComponentMetricSummary.wrap(item)
        }.toList
      )
    override val lineageGroupArn: Optional[LineageGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lineageGroupArn())
        .map(value => zio.aws.sagemaker.model.primitives.LineageGroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrialComponentResponse
  ): zio.aws.sagemaker.model.DescribeTrialComponentResponse.ReadOnly =
    new Wrapper(impl)
}
