package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  TrainingJobName,
  RoleArn,
  LabelingJobArn,
  HyperParameterTuningJobArn,
  Timestamp,
  FailureReason,
  TrainingEnvironmentKey,
  TrainingEnvironmentValue,
  TrainingJobArn,
  HyperParameterKey,
  BillableTimeInSeconds,
  TrainingTimeInSeconds,
  AutoMLJobArn,
  HyperParameterValue
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeTrainingJobResponse(
    trainingJobName: TrainingJobName,
    trainingJobArn: TrainingJobArn,
    tuningJobArn: Optional[HyperParameterTuningJobArn] = Optional.Absent,
    labelingJobArn: Optional[LabelingJobArn] = Optional.Absent,
    autoMLJobArn: Optional[AutoMLJobArn] = Optional.Absent,
    modelArtifacts: zio.aws.sagemaker.model.ModelArtifacts,
    trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus,
    secondaryStatus: zio.aws.sagemaker.model.SecondaryStatus,
    failureReason: Optional[FailureReason] = Optional.Absent,
    hyperParameters: Optional[Map[HyperParameterKey, HyperParameterValue]] =
      Optional.Absent,
    algorithmSpecification: zio.aws.sagemaker.model.AlgorithmSpecification,
    roleArn: Optional[RoleArn] = Optional.Absent,
    inputDataConfig: Optional[Iterable[zio.aws.sagemaker.model.Channel]] =
      Optional.Absent,
    outputDataConfig: Optional[zio.aws.sagemaker.model.OutputDataConfig] =
      Optional.Absent,
    resourceConfig: zio.aws.sagemaker.model.ResourceConfig,
    vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig] = Optional.Absent,
    stoppingCondition: zio.aws.sagemaker.model.StoppingCondition,
    creationTime: Timestamp,
    trainingStartTime: Optional[Timestamp] = Optional.Absent,
    trainingEndTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    secondaryStatusTransitions: Optional[
      Iterable[zio.aws.sagemaker.model.SecondaryStatusTransition]
    ] = Optional.Absent,
    finalMetricDataList: Optional[
      Iterable[zio.aws.sagemaker.model.MetricData]
    ] = Optional.Absent,
    enableNetworkIsolation: Optional[Boolean] = Optional.Absent,
    enableInterContainerTrafficEncryption: Optional[Boolean] = Optional.Absent,
    enableManagedSpotTraining: Optional[Boolean] = Optional.Absent,
    checkpointConfig: Optional[zio.aws.sagemaker.model.CheckpointConfig] =
      Optional.Absent,
    trainingTimeInSeconds: Optional[TrainingTimeInSeconds] = Optional.Absent,
    billableTimeInSeconds: Optional[BillableTimeInSeconds] = Optional.Absent,
    debugHookConfig: Optional[zio.aws.sagemaker.model.DebugHookConfig] =
      Optional.Absent,
    experimentConfig: Optional[zio.aws.sagemaker.model.ExperimentConfig] =
      Optional.Absent,
    debugRuleConfigurations: Optional[
      Iterable[zio.aws.sagemaker.model.DebugRuleConfiguration]
    ] = Optional.Absent,
    tensorBoardOutputConfig: Optional[
      zio.aws.sagemaker.model.TensorBoardOutputConfig
    ] = Optional.Absent,
    debugRuleEvaluationStatuses: Optional[
      Iterable[zio.aws.sagemaker.model.DebugRuleEvaluationStatus]
    ] = Optional.Absent,
    profilerConfig: Optional[zio.aws.sagemaker.model.ProfilerConfig] =
      Optional.Absent,
    profilerRuleConfigurations: Optional[
      Iterable[zio.aws.sagemaker.model.ProfilerRuleConfiguration]
    ] = Optional.Absent,
    profilerRuleEvaluationStatuses: Optional[
      Iterable[zio.aws.sagemaker.model.ProfilerRuleEvaluationStatus]
    ] = Optional.Absent,
    profilingStatus: Optional[zio.aws.sagemaker.model.ProfilingStatus] =
      Optional.Absent,
    retryStrategy: Optional[zio.aws.sagemaker.model.RetryStrategy] =
      Optional.Absent,
    environment: Optional[
      Map[TrainingEnvironmentKey, TrainingEnvironmentValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse = {
    import DescribeTrainingJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse
      .builder()
      .trainingJobName(
        TrainingJobName.unwrap(trainingJobName): java.lang.String
      )
      .trainingJobArn(TrainingJobArn.unwrap(trainingJobArn): java.lang.String)
      .optionallyWith(
        tuningJobArn.map(value =>
          HyperParameterTuningJobArn.unwrap(value): java.lang.String
        )
      )(_.tuningJobArn)
      .optionallyWith(
        labelingJobArn.map(value =>
          LabelingJobArn.unwrap(value): java.lang.String
        )
      )(_.labelingJobArn)
      .optionallyWith(
        autoMLJobArn.map(value => AutoMLJobArn.unwrap(value): java.lang.String)
      )(_.autoMLJobArn)
      .modelArtifacts(modelArtifacts.buildAwsValue())
      .trainingJobStatus(trainingJobStatus.unwrap)
      .secondaryStatus(secondaryStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (HyperParameterKey.unwrap(
                key
              ): java.lang.String) -> (HyperParameterValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .algorithmSpecification(algorithmSpecification.buildAwsValue())
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        inputDataConfig.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputDataConfig)
      .optionallyWith(outputDataConfig.map(value => value.buildAwsValue()))(
        _.outputDataConfig
      )
      .resourceConfig(resourceConfig.buildAwsValue())
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .stoppingCondition(stoppingCondition.buildAwsValue())
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        trainingStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingStartTime)
      .optionallyWith(
        trainingEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.trainingEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        secondaryStatusTransitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secondaryStatusTransitions)
      .optionallyWith(
        finalMetricDataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalMetricDataList)
      .optionallyWith(
        enableNetworkIsolation.map(value => value: java.lang.Boolean)
      )(_.enableNetworkIsolation)
      .optionallyWith(
        enableInterContainerTrafficEncryption.map(value =>
          value: java.lang.Boolean
        )
      )(_.enableInterContainerTrafficEncryption)
      .optionallyWith(
        enableManagedSpotTraining.map(value => value: java.lang.Boolean)
      )(_.enableManagedSpotTraining)
      .optionallyWith(checkpointConfig.map(value => value.buildAwsValue()))(
        _.checkpointConfig
      )
      .optionallyWith(
        trainingTimeInSeconds.map(value =>
          TrainingTimeInSeconds.unwrap(value): Integer
        )
      )(_.trainingTimeInSeconds)
      .optionallyWith(
        billableTimeInSeconds.map(value =>
          BillableTimeInSeconds.unwrap(value): Integer
        )
      )(_.billableTimeInSeconds)
      .optionallyWith(debugHookConfig.map(value => value.buildAwsValue()))(
        _.debugHookConfig
      )
      .optionallyWith(experimentConfig.map(value => value.buildAwsValue()))(
        _.experimentConfig
      )
      .optionallyWith(
        debugRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.debugRuleConfigurations)
      .optionallyWith(
        tensorBoardOutputConfig.map(value => value.buildAwsValue())
      )(_.tensorBoardOutputConfig)
      .optionallyWith(
        debugRuleEvaluationStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.debugRuleEvaluationStatuses)
      .optionallyWith(profilerConfig.map(value => value.buildAwsValue()))(
        _.profilerConfig
      )
      .optionallyWith(
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profilerRuleConfigurations)
      .optionallyWith(
        profilerRuleEvaluationStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.profilerRuleEvaluationStatuses)
      .optionallyWith(profilingStatus.map(value => value.unwrap))(
        _.profilingStatus
      )
      .optionallyWith(retryStrategy.map(value => value.buildAwsValue()))(
        _.retryStrategy
      )
      .optionallyWith(
        environment.map(value =>
          value
            .map({ case (key, value) =>
              (TrainingEnvironmentKey
                .unwrap(key): java.lang.String) -> (TrainingEnvironmentValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.environment)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly =
    zio.aws.sagemaker.model.DescribeTrainingJobResponse.wrap(buildAwsValue())
}
object DescribeTrainingJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DescribeTrainingJobResponse =
      zio.aws.sagemaker.model.DescribeTrainingJobResponse(
        trainingJobName,
        trainingJobArn,
        tuningJobArn.map(value => value),
        labelingJobArn.map(value => value),
        autoMLJobArn.map(value => value),
        modelArtifacts.asEditable,
        trainingJobStatus,
        secondaryStatus,
        failureReason.map(value => value),
        hyperParameters.map(value => value),
        algorithmSpecification.asEditable,
        roleArn.map(value => value),
        inputDataConfig.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputDataConfig.map(value => value.asEditable),
        resourceConfig.asEditable,
        vpcConfig.map(value => value.asEditable),
        stoppingCondition.asEditable,
        creationTime,
        trainingStartTime.map(value => value),
        trainingEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        secondaryStatusTransitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        finalMetricDataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        enableNetworkIsolation.map(value => value),
        enableInterContainerTrafficEncryption.map(value => value),
        enableManagedSpotTraining.map(value => value),
        checkpointConfig.map(value => value.asEditable),
        trainingTimeInSeconds.map(value => value),
        billableTimeInSeconds.map(value => value),
        debugHookConfig.map(value => value.asEditable),
        experimentConfig.map(value => value.asEditable),
        debugRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tensorBoardOutputConfig.map(value => value.asEditable),
        debugRuleEvaluationStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        profilerConfig.map(value => value.asEditable),
        profilerRuleConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        profilerRuleEvaluationStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        profilingStatus.map(value => value),
        retryStrategy.map(value => value.asEditable),
        environment.map(value => value)
      )
    def trainingJobName: TrainingJobName
    def trainingJobArn: TrainingJobArn
    def tuningJobArn: Optional[HyperParameterTuningJobArn]
    def labelingJobArn: Optional[LabelingJobArn]
    def autoMLJobArn: Optional[AutoMLJobArn]
    def modelArtifacts: zio.aws.sagemaker.model.ModelArtifacts.ReadOnly
    def trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus
    def secondaryStatus: zio.aws.sagemaker.model.SecondaryStatus
    def failureReason: Optional[FailureReason]
    def hyperParameters: Optional[Map[HyperParameterKey, HyperParameterValue]]
    def algorithmSpecification
        : zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly
    def roleArn: Optional[RoleArn]
    def inputDataConfig
        : Optional[List[zio.aws.sagemaker.model.Channel.ReadOnly]]
    def outputDataConfig
        : Optional[zio.aws.sagemaker.model.OutputDataConfig.ReadOnly]
    def resourceConfig: zio.aws.sagemaker.model.ResourceConfig.ReadOnly
    def vpcConfig: Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly]
    def stoppingCondition: zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    def creationTime: Timestamp
    def trainingStartTime: Optional[Timestamp]
    def trainingEndTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def secondaryStatusTransitions: Optional[
      List[zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly]
    ]
    def finalMetricDataList
        : Optional[List[zio.aws.sagemaker.model.MetricData.ReadOnly]]
    def enableNetworkIsolation: Optional[Boolean]
    def enableInterContainerTrafficEncryption: Optional[Boolean]
    def enableManagedSpotTraining: Optional[Boolean]
    def checkpointConfig
        : Optional[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly]
    def trainingTimeInSeconds: Optional[TrainingTimeInSeconds]
    def billableTimeInSeconds: Optional[BillableTimeInSeconds]
    def debugHookConfig
        : Optional[zio.aws.sagemaker.model.DebugHookConfig.ReadOnly]
    def experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly]
    def debugRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly]
    ]
    def tensorBoardOutputConfig
        : Optional[zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly]
    def debugRuleEvaluationStatuses: Optional[
      List[zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly]
    ]
    def profilerConfig
        : Optional[zio.aws.sagemaker.model.ProfilerConfig.ReadOnly]
    def profilerRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ]
    def profilerRuleEvaluationStatuses: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleEvaluationStatus.ReadOnly]
    ]
    def profilingStatus: Optional[zio.aws.sagemaker.model.ProfilingStatus]
    def retryStrategy: Optional[zio.aws.sagemaker.model.RetryStrategy.ReadOnly]
    def environment
        : Optional[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]]
    def getTrainingJobName: ZIO[Any, Nothing, TrainingJobName] =
      ZIO.succeed(trainingJobName)
    def getTrainingJobArn: ZIO[Any, Nothing, TrainingJobArn] =
      ZIO.succeed(trainingJobArn)
    def getTuningJobArn: ZIO[Any, AwsError, HyperParameterTuningJobArn] =
      AwsError.unwrapOptionField("tuningJobArn", tuningJobArn)
    def getLabelingJobArn: ZIO[Any, AwsError, LabelingJobArn] =
      AwsError.unwrapOptionField("labelingJobArn", labelingJobArn)
    def getAutoMLJobArn: ZIO[Any, AwsError, AutoMLJobArn] =
      AwsError.unwrapOptionField("autoMLJobArn", autoMLJobArn)
    def getModelArtifacts
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ModelArtifacts.ReadOnly] =
      ZIO.succeed(modelArtifacts)
    def getTrainingJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TrainingJobStatus] =
      ZIO.succeed(trainingJobStatus)
    def getSecondaryStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.SecondaryStatus] =
      ZIO.succeed(secondaryStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getHyperParameters
        : ZIO[Any, AwsError, Map[HyperParameterKey, HyperParameterValue]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getAlgorithmSpecification: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly
    ] = ZIO.succeed(algorithmSpecification)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getInputDataConfig
        : ZIO[Any, AwsError, List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      AwsError.unwrapOptionField("inputDataConfig", inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.OutputDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("outputDataConfig", outputDataConfig)
    def getResourceConfig
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ResourceConfig.ReadOnly] =
      ZIO.succeed(resourceConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getStoppingCondition: ZIO[
      Any,
      Nothing,
      zio.aws.sagemaker.model.StoppingCondition.ReadOnly
    ] = ZIO.succeed(stoppingCondition)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getTrainingStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingStartTime", trainingStartTime)
    def getTrainingEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("trainingEndTime", trainingEndTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getSecondaryStatusTransitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "secondaryStatusTransitions",
      secondaryStatusTransitions
    )
    def getFinalMetricDataList: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricData.ReadOnly
    ]] = AwsError.unwrapOptionField("finalMetricDataList", finalMetricDataList)
    def getEnableNetworkIsolation: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableNetworkIsolation", enableNetworkIsolation)
    def getEnableInterContainerTrafficEncryption: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableInterContainerTrafficEncryption",
        enableInterContainerTrafficEncryption
      )
    def getEnableManagedSpotTraining: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableManagedSpotTraining", enableManagedSpotTraining)
    def getCheckpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.CheckpointConfig.ReadOnly
    ] = AwsError.unwrapOptionField("checkpointConfig", checkpointConfig)
    def getTrainingTimeInSeconds: ZIO[Any, AwsError, TrainingTimeInSeconds] =
      AwsError.unwrapOptionField("trainingTimeInSeconds", trainingTimeInSeconds)
    def getBillableTimeInSeconds: ZIO[Any, AwsError, BillableTimeInSeconds] =
      AwsError.unwrapOptionField("billableTimeInSeconds", billableTimeInSeconds)
    def getDebugHookConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.DebugHookConfig.ReadOnly] =
      AwsError.unwrapOptionField("debugHookConfig", debugHookConfig)
    def getExperimentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.ExperimentConfig.ReadOnly
    ] = AwsError.unwrapOptionField("experimentConfig", experimentConfig)
    def getDebugRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "debugRuleConfigurations",
      debugRuleConfigurations
    )
    def getTensorBoardOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "tensorBoardOutputConfig",
      tensorBoardOutputConfig
    )
    def getDebugRuleEvaluationStatuses: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "debugRuleEvaluationStatuses",
      debugRuleEvaluationStatuses
    )
    def getProfilerConfig
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProfilerConfig.ReadOnly] =
      AwsError.unwrapOptionField("profilerConfig", profilerConfig)
    def getProfilerRuleConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "profilerRuleConfigurations",
      profilerRuleConfigurations
    )
    def getProfilerRuleEvaluationStatuses: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.ProfilerRuleEvaluationStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "profilerRuleEvaluationStatuses",
      profilerRuleEvaluationStatuses
    )
    def getProfilingStatus
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.ProfilingStatus] =
      AwsError.unwrapOptionField("profilingStatus", profilingStatus)
    def getRetryStrategy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      AwsError.unwrapOptionField("retryStrategy", retryStrategy)
    def getEnvironment: ZIO[Any, AwsError, Map[
      TrainingEnvironmentKey,
      TrainingEnvironmentValue
    ]] = AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse
  ) extends zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly {
    override val trainingJobName: TrainingJobName =
      zio.aws.sagemaker.model.primitives.TrainingJobName(impl.trainingJobName())
    override val trainingJobArn: TrainingJobArn =
      zio.aws.sagemaker.model.primitives.TrainingJobArn(impl.trainingJobArn())
    override val tuningJobArn: Optional[HyperParameterTuningJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tuningJobArn())
        .map(value =>
          zio.aws.sagemaker.model.primitives.HyperParameterTuningJobArn(value)
        )
    override val labelingJobArn: Optional[LabelingJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelingJobArn())
        .map(value => zio.aws.sagemaker.model.primitives.LabelingJobArn(value))
    override val autoMLJobArn: Optional[AutoMLJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.autoMLJobArn())
      .map(value => zio.aws.sagemaker.model.primitives.AutoMLJobArn(value))
    override val modelArtifacts
        : zio.aws.sagemaker.model.ModelArtifacts.ReadOnly =
      zio.aws.sagemaker.model.ModelArtifacts.wrap(impl.modelArtifacts())
    override val trainingJobStatus: zio.aws.sagemaker.model.TrainingJobStatus =
      zio.aws.sagemaker.model.TrainingJobStatus.wrap(impl.trainingJobStatus())
    override val secondaryStatus: zio.aws.sagemaker.model.SecondaryStatus =
      zio.aws.sagemaker.model.SecondaryStatus.wrap(impl.secondaryStatus())
    override val failureReason: Optional[FailureReason] = zio.aws.core.internal
      .optionalFromNullable(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
    override val hyperParameters
        : Optional[Map[HyperParameterKey, HyperParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.HyperParameterKey(
                key
              ) -> zio.aws.sagemaker.model.primitives.HyperParameterValue(value)
            })
            .toMap
        )
    override val algorithmSpecification
        : zio.aws.sagemaker.model.AlgorithmSpecification.ReadOnly =
      zio.aws.sagemaker.model.AlgorithmSpecification
        .wrap(impl.algorithmSpecification())
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sagemaker.model.primitives.RoleArn(value))
    override val inputDataConfig
        : Optional[List[zio.aws.sagemaker.model.Channel.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputDataConfig())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.Channel.wrap(item)
          }.toList
        )
    override val outputDataConfig
        : Optional[zio.aws.sagemaker.model.OutputDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputDataConfig())
        .map(value => zio.aws.sagemaker.model.OutputDataConfig.wrap(value))
    override val resourceConfig
        : zio.aws.sagemaker.model.ResourceConfig.ReadOnly =
      zio.aws.sagemaker.model.ResourceConfig.wrap(impl.resourceConfig())
    override val vpcConfig
        : Optional[zio.aws.sagemaker.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.sagemaker.model.VpcConfig.wrap(value))
    override val stoppingCondition
        : zio.aws.sagemaker.model.StoppingCondition.ReadOnly =
      zio.aws.sagemaker.model.StoppingCondition.wrap(impl.stoppingCondition())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val trainingStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingStartTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val trainingEndTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.trainingEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val secondaryStatusTransitions: Optional[
      List[zio.aws.sagemaker.model.SecondaryStatusTransition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secondaryStatusTransitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.SecondaryStatusTransition.wrap(item)
        }.toList
      )
    override val finalMetricDataList
        : Optional[List[zio.aws.sagemaker.model.MetricData.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.finalMetricDataList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MetricData.wrap(item)
          }.toList
        )
    override val enableNetworkIsolation: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableNetworkIsolation())
        .map(value => value: Boolean)
    override val enableInterContainerTrafficEncryption: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableInterContainerTrafficEncryption())
        .map(value => value: Boolean)
    override val enableManagedSpotTraining: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableManagedSpotTraining())
        .map(value => value: Boolean)
    override val checkpointConfig
        : Optional[zio.aws.sagemaker.model.CheckpointConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointConfig())
        .map(value => zio.aws.sagemaker.model.CheckpointConfig.wrap(value))
    override val trainingTimeInSeconds: Optional[TrainingTimeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingTimeInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.TrainingTimeInSeconds(value)
        )
    override val billableTimeInSeconds: Optional[BillableTimeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billableTimeInSeconds())
        .map(value =>
          zio.aws.sagemaker.model.primitives.BillableTimeInSeconds(value)
        )
    override val debugHookConfig
        : Optional[zio.aws.sagemaker.model.DebugHookConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.debugHookConfig())
        .map(value => zio.aws.sagemaker.model.DebugHookConfig.wrap(value))
    override val experimentConfig
        : Optional[zio.aws.sagemaker.model.ExperimentConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.experimentConfig())
        .map(value => zio.aws.sagemaker.model.ExperimentConfig.wrap(value))
    override val debugRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.DebugRuleConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.debugRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DebugRuleConfiguration.wrap(item)
        }.toList
      )
    override val tensorBoardOutputConfig
        : Optional[zio.aws.sagemaker.model.TensorBoardOutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tensorBoardOutputConfig())
        .map(value =>
          zio.aws.sagemaker.model.TensorBoardOutputConfig.wrap(value)
        )
    override val debugRuleEvaluationStatuses: Optional[
      List[zio.aws.sagemaker.model.DebugRuleEvaluationStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.debugRuleEvaluationStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.DebugRuleEvaluationStatus.wrap(item)
        }.toList
      )
    override val profilerConfig
        : Optional[zio.aws.sagemaker.model.ProfilerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profilerConfig())
        .map(value => zio.aws.sagemaker.model.ProfilerConfig.wrap(value))
    override val profilerRuleConfigurations: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.profilerRuleConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProfilerRuleConfiguration.wrap(item)
        }.toList
      )
    override val profilerRuleEvaluationStatuses: Optional[
      List[zio.aws.sagemaker.model.ProfilerRuleEvaluationStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.profilerRuleEvaluationStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.ProfilerRuleEvaluationStatus.wrap(item)
        }.toList
      )
    override val profilingStatus
        : Optional[zio.aws.sagemaker.model.ProfilingStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.profilingStatus())
        .map(value => zio.aws.sagemaker.model.ProfilingStatus.wrap(value))
    override val retryStrategy
        : Optional[zio.aws.sagemaker.model.RetryStrategy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retryStrategy())
        .map(value => zio.aws.sagemaker.model.RetryStrategy.wrap(value))
    override val environment
        : Optional[Map[TrainingEnvironmentKey, TrainingEnvironmentValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.sagemaker.model.primitives.TrainingEnvironmentKey(
                key
              ) -> zio.aws.sagemaker.model.primitives
                .TrainingEnvironmentValue(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DescribeTrainingJobResponse
  ): zio.aws.sagemaker.model.DescribeTrainingJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
