package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.ProjectEntityName
import scala.jdk.CollectionConverters.*
final case class DeleteProjectRequest(projectName: ProjectEntityName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest = {
    import DeleteProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest
      .builder()
      .projectName(ProjectEntityName.unwrap(projectName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteProjectRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteProjectRequest.wrap(buildAwsValue())
}
object DeleteProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteProjectRequest =
      zio.aws.sagemaker.model.DeleteProjectRequest(projectName)
    def projectName: ProjectEntityName
    def getProjectName: ZIO[Any, Nothing, ProjectEntityName] =
      ZIO.succeed(projectName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest
  ) extends zio.aws.sagemaker.model.DeleteProjectRequest.ReadOnly {
    override val projectName: ProjectEntityName =
      zio.aws.sagemaker.model.primitives.ProjectEntityName(impl.projectName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteProjectRequest
  ): zio.aws.sagemaker.model.DeleteProjectRequest.ReadOnly = new Wrapper(impl)
}
