package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.FlowDefinitionName
import scala.jdk.CollectionConverters.*
final case class DeleteFlowDefinitionRequest(
    flowDefinitionName: FlowDefinitionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest = {
    import DeleteFlowDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest
      .builder()
      .flowDefinitionName(
        FlowDefinitionName.unwrap(flowDefinitionName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.DeleteFlowDefinitionRequest.ReadOnly =
    zio.aws.sagemaker.model.DeleteFlowDefinitionRequest.wrap(buildAwsValue())
}
object DeleteFlowDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.DeleteFlowDefinitionRequest =
      zio.aws.sagemaker.model.DeleteFlowDefinitionRequest(flowDefinitionName)
    def flowDefinitionName: FlowDefinitionName
    def getFlowDefinitionName: ZIO[Any, Nothing, FlowDefinitionName] =
      ZIO.succeed(flowDefinitionName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest
  ) extends zio.aws.sagemaker.model.DeleteFlowDefinitionRequest.ReadOnly {
    override val flowDefinitionName: FlowDefinitionName =
      zio.aws.sagemaker.model.primitives
        .FlowDefinitionName(impl.flowDefinitionName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.DeleteFlowDefinitionRequest
  ): zio.aws.sagemaker.model.DeleteFlowDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
