package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.EndpointArn
import scala.jdk.CollectionConverters.*
final case class CreateEndpointResponse(endpointArn: EndpointArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse = {
    import CreateEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse
      .builder()
      .endpointArn(EndpointArn.unwrap(endpointArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly =
    zio.aws.sagemaker.model.CreateEndpointResponse.wrap(buildAwsValue())
}
object CreateEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CreateEndpointResponse =
      zio.aws.sagemaker.model.CreateEndpointResponse(endpointArn)
    def endpointArn: EndpointArn
    def getEndpointArn: ZIO[Any, Nothing, EndpointArn] =
      ZIO.succeed(endpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse
  ) extends zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly {
    override val endpointArn: EndpointArn =
      zio.aws.sagemaker.model.primitives.EndpointArn(impl.endpointArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CreateEndpointResponse
  ): zio.aws.sagemaker.model.CreateEndpointResponse.ReadOnly = new Wrapper(impl)
}
