package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.CapacitySizeValue
import scala.jdk.CollectionConverters.*
final case class CapacitySize(
    `type`: zio.aws.sagemaker.model.CapacitySizeType,
    value: CapacitySizeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.CapacitySize = {
    import CapacitySize.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.CapacitySize
      .builder()
      .`type`(`type`.unwrap)
      .value(CapacitySizeValue.unwrap(value): Integer)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.CapacitySize.ReadOnly =
    zio.aws.sagemaker.model.CapacitySize.wrap(buildAwsValue())
}
object CapacitySize {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.CapacitySize
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.CapacitySize =
      zio.aws.sagemaker.model.CapacitySize(`type`, value)
    def `type`: zio.aws.sagemaker.model.CapacitySizeType
    def value: CapacitySizeValue
    def getType: ZIO[Any, Nothing, zio.aws.sagemaker.model.CapacitySizeType] =
      ZIO.succeed(`type`)
    def getValue: ZIO[Any, Nothing, CapacitySizeValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.CapacitySize
  ) extends zio.aws.sagemaker.model.CapacitySize.ReadOnly {
    override val `type`: zio.aws.sagemaker.model.CapacitySizeType =
      zio.aws.sagemaker.model.CapacitySizeType.wrap(impl.`type`())
    override val value: CapacitySizeValue =
      zio.aws.sagemaker.model.primitives.CapacitySizeValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.CapacitySize
  ): zio.aws.sagemaker.model.CapacitySize.ReadOnly = new Wrapper(impl)
}
