package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  FailureReason,
  Timestamp,
  TransformJobArn,
  TransformJobName
}
import scala.jdk.CollectionConverters.*
final case class TransformJobSummary(
    transformJobName: TransformJobName,
    transformJobArn: TransformJobArn,
    creationTime: Timestamp,
    transformEndTime: Option[Timestamp] = None,
    lastModifiedTime: Option[Timestamp] = None,
    transformJobStatus: zio.aws.sagemaker.model.TransformJobStatus,
    failureReason: Option[FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TransformJobSummary = {
    import TransformJobSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TransformJobSummary
      .builder()
      .transformJobName(
        TransformJobName.unwrap(transformJobName): java.lang.String
      )
      .transformJobArn(
        TransformJobArn.unwrap(transformJobArn): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        transformEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.transformEndTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .transformJobStatus(transformJobStatus.unwrap)
      .optionallyWith(
        failureReason.map(value =>
          FailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TransformJobSummary.ReadOnly =
    zio.aws.sagemaker.model.TransformJobSummary.wrap(buildAwsValue())
}
object TransformJobSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TransformJobSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TransformJobSummary =
      zio.aws.sagemaker.model.TransformJobSummary(
        transformJobName,
        transformJobArn,
        creationTime,
        transformEndTime.map(value => value),
        lastModifiedTime.map(value => value),
        transformJobStatus,
        failureReason.map(value => value)
      )
    def transformJobName: TransformJobName
    def transformJobArn: TransformJobArn
    def creationTime: Timestamp
    def transformEndTime: Option[Timestamp]
    def lastModifiedTime: Option[Timestamp]
    def transformJobStatus: zio.aws.sagemaker.model.TransformJobStatus
    def failureReason: Option[FailureReason]
    def getTransformJobName: ZIO[Any, Nothing, TransformJobName] =
      ZIO.succeed(transformJobName)
    def getTransformJobArn: ZIO[Any, Nothing, TransformJobArn] =
      ZIO.succeed(transformJobArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getTransformEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("transformEndTime", transformEndTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTransformJobStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.TransformJobStatus] =
      ZIO.succeed(transformJobStatus)
    def getFailureReason: ZIO[Any, AwsError, FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJobSummary
  ) extends zio.aws.sagemaker.model.TransformJobSummary.ReadOnly {
    override val transformJobName: TransformJobName =
      zio.aws.sagemaker.model.primitives
        .TransformJobName(impl.transformJobName())
    override val transformJobArn: TransformJobArn =
      zio.aws.sagemaker.model.primitives.TransformJobArn(impl.transformJobArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val transformEndTime: Option[Timestamp] = scala
      .Option(impl.transformEndTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val lastModifiedTime: Option[Timestamp] = scala
      .Option(impl.lastModifiedTime())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val transformJobStatus
        : zio.aws.sagemaker.model.TransformJobStatus =
      zio.aws.sagemaker.model.TransformJobStatus.wrap(impl.transformJobStatus())
    override val failureReason: Option[FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.sagemaker.model.primitives.FailureReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TransformJobSummary
  ): zio.aws.sagemaker.model.TransformJobSummary.ReadOnly = new Wrapper(impl)
}
