package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{ImageDigest, ContainerImage}
import scala.jdk.CollectionConverters.*
final case class TrainingSpecification(
    trainingImage: ContainerImage,
    trainingImageDigest: Option[ImageDigest] = None,
    supportedHyperParameters: Option[
      Iterable[zio.aws.sagemaker.model.HyperParameterSpecification]
    ] = None,
    supportedTrainingInstanceTypes: Iterable[
      zio.aws.sagemaker.model.TrainingInstanceType
    ],
    supportsDistributedTraining: Option[Boolean] = None,
    metricDefinitions: Option[
      Iterable[zio.aws.sagemaker.model.MetricDefinition]
    ] = None,
    trainingChannels: Iterable[zio.aws.sagemaker.model.ChannelSpecification],
    supportedTuningJobObjectiveMetrics: Option[
      Iterable[zio.aws.sagemaker.model.HyperParameterTuningJobObjective]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.TrainingSpecification = {
    import TrainingSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.TrainingSpecification
      .builder()
      .trainingImage(ContainerImage.unwrap(trainingImage): java.lang.String)
      .optionallyWith(
        trainingImageDigest.map(value =>
          ImageDigest.unwrap(value): java.lang.String
        )
      )(_.trainingImageDigest)
      .optionallyWith(
        supportedHyperParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedHyperParameters)
      .supportedTrainingInstanceTypesWithStrings(
        supportedTrainingInstanceTypes.map { item =>
          item.unwrap.toString
        }.asJavaCollection
      )
      .optionallyWith(
        supportsDistributedTraining.map(value => value: java.lang.Boolean)
      )(_.supportsDistributedTraining)
      .optionallyWith(
        metricDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDefinitions)
      .trainingChannels(trainingChannels.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        supportedTuningJobObjectiveMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.supportedTuningJobObjectiveMetrics)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.TrainingSpecification.ReadOnly =
    zio.aws.sagemaker.model.TrainingSpecification.wrap(buildAwsValue())
}
object TrainingSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.TrainingSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.TrainingSpecification =
      zio.aws.sagemaker.model.TrainingSpecification(
        trainingImage,
        trainingImageDigest.map(value => value),
        supportedHyperParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        supportedTrainingInstanceTypes,
        supportsDistributedTraining.map(value => value),
        metricDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        trainingChannels.map { item =>
          item.asEditable
        },
        supportedTuningJobObjectiveMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trainingImage: ContainerImage
    def trainingImageDigest: Option[ImageDigest]
    def supportedHyperParameters: Option[
      List[zio.aws.sagemaker.model.HyperParameterSpecification.ReadOnly]
    ]
    def supportedTrainingInstanceTypes
        : List[zio.aws.sagemaker.model.TrainingInstanceType]
    def supportsDistributedTraining: Option[Boolean]
    def metricDefinitions
        : Option[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]]
    def trainingChannels
        : List[zio.aws.sagemaker.model.ChannelSpecification.ReadOnly]
    def supportedTuningJobObjectiveMetrics: Option[
      List[zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly]
    ]
    def getTrainingImage: ZIO[Any, Nothing, ContainerImage] =
      ZIO.succeed(trainingImage)
    def getTrainingImageDigest: ZIO[Any, AwsError, ImageDigest] =
      AwsError.unwrapOptionField("trainingImageDigest", trainingImageDigest)
    def getSupportedHyperParameters: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "supportedHyperParameters",
      supportedHyperParameters
    )
    def getSupportedTrainingInstanceTypes: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.TrainingInstanceType
    ]] = ZIO.succeed(supportedTrainingInstanceTypes)
    def getSupportsDistributedTraining: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsDistributedTraining",
        supportsDistributedTraining
      )
    def getMetricDefinitions: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.MetricDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDefinitions", metricDefinitions)
    def getTrainingChannels: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ChannelSpecification.ReadOnly
    ]] = ZIO.succeed(trainingChannels)
    def getSupportedTuningJobObjectiveMetrics: ZIO[Any, AwsError, List[
      zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "supportedTuningJobObjectiveMetrics",
      supportedTuningJobObjectiveMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingSpecification
  ) extends zio.aws.sagemaker.model.TrainingSpecification.ReadOnly {
    override val trainingImage: ContainerImage =
      zio.aws.sagemaker.model.primitives.ContainerImage(impl.trainingImage())
    override val trainingImageDigest: Option[ImageDigest] = scala
      .Option(impl.trainingImageDigest())
      .map(value => zio.aws.sagemaker.model.primitives.ImageDigest(value))
    override val supportedHyperParameters: Option[
      List[zio.aws.sagemaker.model.HyperParameterSpecification.ReadOnly]
    ] = scala
      .Option(impl.supportedHyperParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterSpecification.wrap(item)
        }.toList
      )
    override val supportedTrainingInstanceTypes
        : List[zio.aws.sagemaker.model.TrainingInstanceType] = impl
      .supportedTrainingInstanceTypes()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.TrainingInstanceType.wrap(item)
      }
      .toList
    override val supportsDistributedTraining: Option[Boolean] = scala
      .Option(impl.supportsDistributedTraining())
      .map(value => value: Boolean)
    override val metricDefinitions
        : Option[List[zio.aws.sagemaker.model.MetricDefinition.ReadOnly]] =
      scala
        .Option(impl.metricDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sagemaker.model.MetricDefinition.wrap(item)
          }.toList
        )
    override val trainingChannels
        : List[zio.aws.sagemaker.model.ChannelSpecification.ReadOnly] = impl
      .trainingChannels()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ChannelSpecification.wrap(item)
      }
      .toList
    override val supportedTuningJobObjectiveMetrics: Option[
      List[zio.aws.sagemaker.model.HyperParameterTuningJobObjective.ReadOnly]
    ] = scala
      .Option(impl.supportedTuningJobObjectiveMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sagemaker.model.HyperParameterTuningJobObjective.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.TrainingSpecification
  ): zio.aws.sagemaker.model.TrainingSpecification.ReadOnly = new Wrapper(impl)
}
