package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.sagemaker.model.primitives.LabelingJobName
import scala.jdk.CollectionConverters.*
final case class StopLabelingJobRequest(labelingJobName: LabelingJobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest = {
    import StopLabelingJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest
      .builder()
      .labelingJobName(
        LabelingJobName.unwrap(labelingJobName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.StopLabelingJobRequest.ReadOnly =
    zio.aws.sagemaker.model.StopLabelingJobRequest.wrap(buildAwsValue())
}
object StopLabelingJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.StopLabelingJobRequest =
      zio.aws.sagemaker.model.StopLabelingJobRequest(labelingJobName)
    def labelingJobName: LabelingJobName
    def getLabelingJobName: ZIO[Any, Nothing, LabelingJobName] =
      ZIO.succeed(labelingJobName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest
  ) extends zio.aws.sagemaker.model.StopLabelingJobRequest.ReadOnly {
    override val labelingJobName: LabelingJobName =
      zio.aws.sagemaker.model.primitives.LabelingJobName(impl.labelingJobName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.StopLabelingJobRequest
  ): zio.aws.sagemaker.model.StopLabelingJobRequest.ReadOnly = new Wrapper(impl)
}
