package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{MaxParallelOfTests, MaxNumberOfTests}
import scala.jdk.CollectionConverters.*
final case class RecommendationJobResourceLimit(
    maxNumberOfTests: Option[MaxNumberOfTests] = None,
    maxParallelOfTests: Option[MaxParallelOfTests] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RecommendationJobResourceLimit = {
    import RecommendationJobResourceLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobResourceLimit
      .builder()
      .optionallyWith(
        maxNumberOfTests.map(value => MaxNumberOfTests.unwrap(value): Integer)
      )(_.maxNumberOfTests)
      .optionallyWith(
        maxParallelOfTests.map(value =>
          MaxParallelOfTests.unwrap(value): Integer
        )
      )(_.maxParallelOfTests)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly =
    zio.aws.sagemaker.model.RecommendationJobResourceLimit.wrap(buildAwsValue())
}
object RecommendationJobResourceLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RecommendationJobResourceLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RecommendationJobResourceLimit =
      zio.aws.sagemaker.model.RecommendationJobResourceLimit(
        maxNumberOfTests.map(value => value),
        maxParallelOfTests.map(value => value)
      )
    def maxNumberOfTests: Option[MaxNumberOfTests]
    def maxParallelOfTests: Option[MaxParallelOfTests]
    def getMaxNumberOfTests: ZIO[Any, AwsError, MaxNumberOfTests] =
      AwsError.unwrapOptionField("maxNumberOfTests", maxNumberOfTests)
    def getMaxParallelOfTests: ZIO[Any, AwsError, MaxParallelOfTests] =
      AwsError.unwrapOptionField("maxParallelOfTests", maxParallelOfTests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobResourceLimit
  ) extends zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly {
    override val maxNumberOfTests: Option[MaxNumberOfTests] = scala
      .Option(impl.maxNumberOfTests())
      .map(value => zio.aws.sagemaker.model.primitives.MaxNumberOfTests(value))
    override val maxParallelOfTests: Option[MaxParallelOfTests] = scala
      .Option(impl.maxParallelOfTests())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MaxParallelOfTests(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RecommendationJobResourceLimit
  ): zio.aws.sagemaker.model.RecommendationJobResourceLimit.ReadOnly =
    new Wrapper(impl)
}
