package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RStudioServerProAppSettings(
    accessStatus: Option[zio.aws.sagemaker.model.RStudioServerProAccessStatus] =
      None,
    userGroup: Option[zio.aws.sagemaker.model.RStudioServerProUserGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings = {
    import RStudioServerProAppSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
      .builder()
      .optionallyWith(accessStatus.map(value => value.unwrap))(_.accessStatus)
      .optionallyWith(userGroup.map(value => value.unwrap))(_.userGroup)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly =
    zio.aws.sagemaker.model.RStudioServerProAppSettings.wrap(buildAwsValue())
}
object RStudioServerProAppSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.RStudioServerProAppSettings =
      zio.aws.sagemaker.model.RStudioServerProAppSettings(
        accessStatus.map(value => value),
        userGroup.map(value => value)
      )
    def accessStatus
        : Option[zio.aws.sagemaker.model.RStudioServerProAccessStatus]
    def userGroup: Option[zio.aws.sagemaker.model.RStudioServerProUserGroup]
    def getAccessStatus: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProAccessStatus
    ] = AwsError.unwrapOptionField("accessStatus", accessStatus)
    def getUserGroup: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.RStudioServerProUserGroup
    ] = AwsError.unwrapOptionField("userGroup", userGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
  ) extends zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly {
    override val accessStatus
        : Option[zio.aws.sagemaker.model.RStudioServerProAccessStatus] = scala
      .Option(impl.accessStatus())
      .map(value =>
        zio.aws.sagemaker.model.RStudioServerProAccessStatus.wrap(value)
      )
    override val userGroup
        : Option[zio.aws.sagemaker.model.RStudioServerProUserGroup] = scala
      .Option(impl.userGroup())
      .map(value =>
        zio.aws.sagemaker.model.RStudioServerProUserGroup.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.RStudioServerProAppSettings
  ): zio.aws.sagemaker.model.RStudioServerProAppSettings.ReadOnly = new Wrapper(
    impl
  )
}
