package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  String8192,
  QueryLineageMaxResults,
  QueryLineageMaxDepth,
  AssociationEntityArn
}
import scala.jdk.CollectionConverters.*
final case class QueryLineageRequest(
    startArns: Iterable[AssociationEntityArn],
    direction: Option[zio.aws.sagemaker.model.Direction] = None,
    includeEdges: Option[Boolean] = None,
    filters: Option[zio.aws.sagemaker.model.QueryFilters] = None,
    maxDepth: Option[QueryLineageMaxDepth] = None,
    maxResults: Option[QueryLineageMaxResults] = None,
    nextToken: Option[String8192] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest = {
    import QueryLineageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest
      .builder()
      .startArns(startArns.map { item =>
        AssociationEntityArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(direction.map(value => value.unwrap))(_.direction)
      .optionallyWith(includeEdges.map(value => value: java.lang.Boolean))(
        _.includeEdges
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        maxDepth.map(value => QueryLineageMaxDepth.unwrap(value): Integer)
      )(_.maxDepth)
      .optionallyWith(
        maxResults.map(value => QueryLineageMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => String8192.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.QueryLineageRequest.ReadOnly =
    zio.aws.sagemaker.model.QueryLineageRequest.wrap(buildAwsValue())
}
object QueryLineageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.QueryLineageRequest =
      zio.aws.sagemaker.model.QueryLineageRequest(
        startArns,
        direction.map(value => value),
        includeEdges.map(value => value),
        filters.map(value => value.asEditable),
        maxDepth.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def startArns: List[AssociationEntityArn]
    def direction: Option[zio.aws.sagemaker.model.Direction]
    def includeEdges: Option[Boolean]
    def filters: Option[zio.aws.sagemaker.model.QueryFilters.ReadOnly]
    def maxDepth: Option[QueryLineageMaxDepth]
    def maxResults: Option[QueryLineageMaxResults]
    def nextToken: Option[String8192]
    def getStartArns: ZIO[Any, Nothing, List[AssociationEntityArn]] =
      ZIO.succeed(startArns)
    def getDirection: ZIO[Any, AwsError, zio.aws.sagemaker.model.Direction] =
      AwsError.unwrapOptionField("direction", direction)
    def getIncludeEdges: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeEdges", includeEdges)
    def getFilters
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.QueryFilters.ReadOnly] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxDepth: ZIO[Any, AwsError, QueryLineageMaxDepth] =
      AwsError.unwrapOptionField("maxDepth", maxDepth)
    def getMaxResults: ZIO[Any, AwsError, QueryLineageMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String8192] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest
  ) extends zio.aws.sagemaker.model.QueryLineageRequest.ReadOnly {
    override val startArns: List[AssociationEntityArn] = impl
      .startArns()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.primitives.AssociationEntityArn(item)
      }
      .toList
    override val direction: Option[zio.aws.sagemaker.model.Direction] = scala
      .Option(impl.direction())
      .map(value => zio.aws.sagemaker.model.Direction.wrap(value))
    override val includeEdges: Option[Boolean] =
      scala.Option(impl.includeEdges()).map(value => value: Boolean)
    override val filters
        : Option[zio.aws.sagemaker.model.QueryFilters.ReadOnly] = scala
      .Option(impl.filters())
      .map(value => zio.aws.sagemaker.model.QueryFilters.wrap(value))
    override val maxDepth: Option[QueryLineageMaxDepth] = scala
      .Option(impl.maxDepth())
      .map(value =>
        zio.aws.sagemaker.model.primitives.QueryLineageMaxDepth(value)
      )
    override val maxResults: Option[QueryLineageMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.sagemaker.model.primitives.QueryLineageMaxResults(value)
      )
    override val nextToken: Option[String8192] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.String8192(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest
  ): zio.aws.sagemaker.model.QueryLineageRequest.ReadOnly = new Wrapper(impl)
}
