package zio.aws.sagemaker.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.{
  TrafficDurationInSeconds,
  SpawnRate,
  InitialNumberOfUsers
}
import scala.jdk.CollectionConverters.*
final case class Phase(
    initialNumberOfUsers: Option[InitialNumberOfUsers] = None,
    spawnRate: Option[SpawnRate] = None,
    durationInSeconds: Option[TrafficDurationInSeconds] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.sagemaker.model.Phase = {
    import Phase.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.Phase
      .builder()
      .optionallyWith(
        initialNumberOfUsers.map(value =>
          InitialNumberOfUsers.unwrap(value): Integer
        )
      )(_.initialNumberOfUsers)
      .optionallyWith(spawnRate.map(value => SpawnRate.unwrap(value): Integer))(
        _.spawnRate
      )
      .optionallyWith(
        durationInSeconds.map(value =>
          TrafficDurationInSeconds.unwrap(value): Integer
        )
      )(_.durationInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.Phase.ReadOnly =
    zio.aws.sagemaker.model.Phase.wrap(buildAwsValue())
}
object Phase {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sagemaker.model.Phase] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.Phase =
      zio.aws.sagemaker.model.Phase(
        initialNumberOfUsers.map(value => value),
        spawnRate.map(value => value),
        durationInSeconds.map(value => value)
      )
    def initialNumberOfUsers: Option[InitialNumberOfUsers]
    def spawnRate: Option[SpawnRate]
    def durationInSeconds: Option[TrafficDurationInSeconds]
    def getInitialNumberOfUsers: ZIO[Any, AwsError, InitialNumberOfUsers] =
      AwsError.unwrapOptionField("initialNumberOfUsers", initialNumberOfUsers)
    def getSpawnRate: ZIO[Any, AwsError, SpawnRate] =
      AwsError.unwrapOptionField("spawnRate", spawnRate)
    def getDurationInSeconds: ZIO[Any, AwsError, TrafficDurationInSeconds] =
      AwsError.unwrapOptionField("durationInSeconds", durationInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.Phase
  ) extends zio.aws.sagemaker.model.Phase.ReadOnly {
    override val initialNumberOfUsers: Option[InitialNumberOfUsers] = scala
      .Option(impl.initialNumberOfUsers())
      .map(value =>
        zio.aws.sagemaker.model.primitives.InitialNumberOfUsers(value)
      )
    override val spawnRate: Option[SpawnRate] = scala
      .Option(impl.spawnRate())
      .map(value => zio.aws.sagemaker.model.primitives.SpawnRate(value))
    override val durationInSeconds: Option[TrafficDurationInSeconds] = scala
      .Option(impl.durationInSeconds())
      .map(value =>
        zio.aws.sagemaker.model.primitives.TrafficDurationInSeconds(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.Phase
  ): zio.aws.sagemaker.model.Phase.ReadOnly = new Wrapper(impl)
}
