package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.sagemaker.model.primitives.{
  EndpointName,
  MonitoringJobDefinitionName,
  MonitoringScheduleName,
  Timestamp,
  MonitoringScheduleArn
}
import scala.jdk.CollectionConverters.*
final case class MonitoringScheduleSummary(
    monitoringScheduleName: MonitoringScheduleName,
    monitoringScheduleArn: MonitoringScheduleArn,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    monitoringScheduleStatus: zio.aws.sagemaker.model.ScheduleStatus,
    endpointName: Option[EndpointName] = None,
    monitoringJobDefinitionName: Option[MonitoringJobDefinitionName] = None,
    monitoringType: Option[zio.aws.sagemaker.model.MonitoringType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary = {
    import MonitoringScheduleSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary
      .builder()
      .monitoringScheduleName(
        MonitoringScheduleName.unwrap(monitoringScheduleName): java.lang.String
      )
      .monitoringScheduleArn(
        MonitoringScheduleArn.unwrap(monitoringScheduleArn): java.lang.String
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .monitoringScheduleStatus(monitoringScheduleStatus.unwrap)
      .optionallyWith(
        endpointName.map(value => EndpointName.unwrap(value): java.lang.String)
      )(_.endpointName)
      .optionallyWith(
        monitoringJobDefinitionName.map(value =>
          MonitoringJobDefinitionName.unwrap(value): java.lang.String
        )
      )(_.monitoringJobDefinitionName)
      .optionallyWith(monitoringType.map(value => value.unwrap))(
        _.monitoringType
      )
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly =
    zio.aws.sagemaker.model.MonitoringScheduleSummary.wrap(buildAwsValue())
}
object MonitoringScheduleSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringScheduleSummary =
      zio.aws.sagemaker.model.MonitoringScheduleSummary(
        monitoringScheduleName,
        monitoringScheduleArn,
        creationTime,
        lastModifiedTime,
        monitoringScheduleStatus,
        endpointName.map(value => value),
        monitoringJobDefinitionName.map(value => value),
        monitoringType.map(value => value)
      )
    def monitoringScheduleName: MonitoringScheduleName
    def monitoringScheduleArn: MonitoringScheduleArn
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def monitoringScheduleStatus: zio.aws.sagemaker.model.ScheduleStatus
    def endpointName: Option[EndpointName]
    def monitoringJobDefinitionName: Option[MonitoringJobDefinitionName]
    def monitoringType: Option[zio.aws.sagemaker.model.MonitoringType]
    def getMonitoringScheduleName: ZIO[Any, Nothing, MonitoringScheduleName] =
      ZIO.succeed(monitoringScheduleName)
    def getMonitoringScheduleArn: ZIO[Any, Nothing, MonitoringScheduleArn] =
      ZIO.succeed(monitoringScheduleArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getMonitoringScheduleStatus
        : ZIO[Any, Nothing, zio.aws.sagemaker.model.ScheduleStatus] =
      ZIO.succeed(monitoringScheduleStatus)
    def getEndpointName: ZIO[Any, AwsError, EndpointName] =
      AwsError.unwrapOptionField("endpointName", endpointName)
    def getMonitoringJobDefinitionName
        : ZIO[Any, AwsError, MonitoringJobDefinitionName] =
      AwsError.unwrapOptionField(
        "monitoringJobDefinitionName",
        monitoringJobDefinitionName
      )
    def getMonitoringType
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.MonitoringType] =
      AwsError.unwrapOptionField("monitoringType", monitoringType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary
  ) extends zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly {
    override val monitoringScheduleName: MonitoringScheduleName =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleName(impl.monitoringScheduleName())
    override val monitoringScheduleArn: MonitoringScheduleArn =
      zio.aws.sagemaker.model.primitives
        .MonitoringScheduleArn(impl.monitoringScheduleArn())
    override val creationTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.sagemaker.model.primitives.Timestamp(impl.lastModifiedTime())
    override val monitoringScheduleStatus
        : zio.aws.sagemaker.model.ScheduleStatus =
      zio.aws.sagemaker.model.ScheduleStatus
        .wrap(impl.monitoringScheduleStatus())
    override val endpointName: Option[EndpointName] = scala
      .Option(impl.endpointName())
      .map(value => zio.aws.sagemaker.model.primitives.EndpointName(value))
    override val monitoringJobDefinitionName
        : Option[MonitoringJobDefinitionName] = scala
      .Option(impl.monitoringJobDefinitionName())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MonitoringJobDefinitionName(value)
      )
    override val monitoringType
        : Option[zio.aws.sagemaker.model.MonitoringType] = scala
      .Option(impl.monitoringType())
      .map(value => zio.aws.sagemaker.model.MonitoringType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary
  ): zio.aws.sagemaker.model.MonitoringScheduleSummary.ReadOnly = new Wrapper(
    impl
  )
}
