package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.MonitoringS3Uri
import scala.jdk.CollectionConverters.*
final case class MonitoringGroundTruthS3Input(
    s3Uri: Option[MonitoringS3Uri] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input = {
    import MonitoringGroundTruthS3Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input
      .builder()
      .optionallyWith(
        s3Uri.map(value => MonitoringS3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly =
    zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.wrap(buildAwsValue())
}
object MonitoringGroundTruthS3Input {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MonitoringGroundTruthS3Input =
      zio.aws.sagemaker.model
        .MonitoringGroundTruthS3Input(s3Uri.map(value => value))
    def s3Uri: Option[MonitoringS3Uri]
    def getS3Uri: ZIO[Any, AwsError, MonitoringS3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input
  ) extends zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly {
    override val s3Uri: Option[MonitoringS3Uri] = scala
      .Option(impl.s3Uri())
      .map(value => zio.aws.sagemaker.model.primitives.MonitoringS3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MonitoringGroundTruthS3Input
  ): zio.aws.sagemaker.model.MonitoringGroundTruthS3Input.ReadOnly =
    new Wrapper(impl)
}
