package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.MetadataPropertyValue
import scala.jdk.CollectionConverters.*
final case class MetadataProperties(
    commitId: Option[MetadataPropertyValue] = None,
    repository: Option[MetadataPropertyValue] = None,
    generatedBy: Option[MetadataPropertyValue] = None,
    projectId: Option[MetadataPropertyValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.MetadataProperties = {
    import MetadataProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.MetadataProperties
      .builder()
      .optionallyWith(
        commitId.map(value =>
          MetadataPropertyValue.unwrap(value): java.lang.String
        )
      )(_.commitId)
      .optionallyWith(
        repository.map(value =>
          MetadataPropertyValue.unwrap(value): java.lang.String
        )
      )(_.repository)
      .optionallyWith(
        generatedBy.map(value =>
          MetadataPropertyValue.unwrap(value): java.lang.String
        )
      )(_.generatedBy)
      .optionallyWith(
        projectId.map(value =>
          MetadataPropertyValue.unwrap(value): java.lang.String
        )
      )(_.projectId)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.MetadataProperties.ReadOnly =
    zio.aws.sagemaker.model.MetadataProperties.wrap(buildAwsValue())
}
object MetadataProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.MetadataProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.MetadataProperties =
      zio.aws.sagemaker.model.MetadataProperties(
        commitId.map(value => value),
        repository.map(value => value),
        generatedBy.map(value => value),
        projectId.map(value => value)
      )
    def commitId: Option[MetadataPropertyValue]
    def repository: Option[MetadataPropertyValue]
    def generatedBy: Option[MetadataPropertyValue]
    def projectId: Option[MetadataPropertyValue]
    def getCommitId: ZIO[Any, AwsError, MetadataPropertyValue] =
      AwsError.unwrapOptionField("commitId", commitId)
    def getRepository: ZIO[Any, AwsError, MetadataPropertyValue] =
      AwsError.unwrapOptionField("repository", repository)
    def getGeneratedBy: ZIO[Any, AwsError, MetadataPropertyValue] =
      AwsError.unwrapOptionField("generatedBy", generatedBy)
    def getProjectId: ZIO[Any, AwsError, MetadataPropertyValue] =
      AwsError.unwrapOptionField("projectId", projectId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.MetadataProperties
  ) extends zio.aws.sagemaker.model.MetadataProperties.ReadOnly {
    override val commitId: Option[MetadataPropertyValue] = scala
      .Option(impl.commitId())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MetadataPropertyValue(value)
      )
    override val repository: Option[MetadataPropertyValue] = scala
      .Option(impl.repository())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MetadataPropertyValue(value)
      )
    override val generatedBy: Option[MetadataPropertyValue] = scala
      .Option(impl.generatedBy())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MetadataPropertyValue(value)
      )
    override val projectId: Option[MetadataPropertyValue] = scala
      .Option(impl.projectId())
      .map(value =>
        zio.aws.sagemaker.model.primitives.MetadataPropertyValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.MetadataProperties
  ): zio.aws.sagemaker.model.MetadataProperties.ReadOnly = new Wrapper(impl)
}
