package zio.aws.sagemaker.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sagemaker.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class ListProcessingJobsResponse(
    processingJobSummaries: Iterable[
      zio.aws.sagemaker.model.ProcessingJobSummary
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse = {
    import ListProcessingJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse
      .builder()
      .processingJobSummaries(processingJobSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly =
    zio.aws.sagemaker.model.ListProcessingJobsResponse.wrap(buildAwsValue())
}
object ListProcessingJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListProcessingJobsResponse =
      zio.aws.sagemaker.model.ListProcessingJobsResponse(
        processingJobSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def processingJobSummaries
        : List[zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly]
    def nextToken: Option[NextToken]
    def getProcessingJobSummaries: ZIO[Any, Nothing, List[
      zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly
    ]] = ZIO.succeed(processingJobSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse
  ) extends zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly {
    override val processingJobSummaries
        : List[zio.aws.sagemaker.model.ProcessingJobSummary.ReadOnly] = impl
      .processingJobSummaries()
      .asScala
      .map { item =>
        zio.aws.sagemaker.model.ProcessingJobSummary.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListProcessingJobsResponse
  ): zio.aws.sagemaker.model.ListProcessingJobsResponse.ReadOnly = new Wrapper(
    impl
  )
}
