package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  MaxResults,
  NextToken,
  Timestamp,
  PipelineName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPipelinesRequest(
    pipelineNamePrefix: Option[PipelineName] = None,
    createdAfter: Option[Timestamp] = None,
    createdBefore: Option[Timestamp] = None,
    sortBy: Option[zio.aws.sagemaker.model.SortPipelinesBy] = None,
    sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest = {
    import ListPipelinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest
      .builder()
      .optionallyWith(
        pipelineNamePrefix.map(value =>
          PipelineName.unwrap(value): java.lang.String
        )
      )(_.pipelineNamePrefix)
      .optionallyWith(
        createdAfter.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdAfter)
      .optionallyWith(
        createdBefore.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdBefore)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sagemaker.model.ListPipelinesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListPipelinesRequest.wrap(buildAwsValue())
}
object ListPipelinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListPipelinesRequest =
      zio.aws.sagemaker.model.ListPipelinesRequest(
        pipelineNamePrefix.map(value => value),
        createdAfter.map(value => value),
        createdBefore.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pipelineNamePrefix: Option[PipelineName]
    def createdAfter: Option[Timestamp]
    def createdBefore: Option[Timestamp]
    def sortBy: Option[zio.aws.sagemaker.model.SortPipelinesBy]
    def sortOrder: Option[zio.aws.sagemaker.model.SortOrder]
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getPipelineNamePrefix: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineNamePrefix", pipelineNamePrefix)
    def getCreatedAfter: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAfter", createdAfter)
    def getCreatedBefore: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdBefore", createdBefore)
    def getSortBy: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortPipelinesBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.sagemaker.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest
  ) extends zio.aws.sagemaker.model.ListPipelinesRequest.ReadOnly {
    override val pipelineNamePrefix: Option[PipelineName] = scala
      .Option(impl.pipelineNamePrefix())
      .map(value => zio.aws.sagemaker.model.primitives.PipelineName(value))
    override val createdAfter: Option[Timestamp] = scala
      .Option(impl.createdAfter())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val createdBefore: Option[Timestamp] = scala
      .Option(impl.createdBefore())
      .map(value => zio.aws.sagemaker.model.primitives.Timestamp(value))
    override val sortBy: Option[zio.aws.sagemaker.model.SortPipelinesBy] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.SortPipelinesBy.wrap(value))
    override val sortOrder: Option[zio.aws.sagemaker.model.SortOrder] = scala
      .Option(impl.sortOrder())
      .map(value => zio.aws.sagemaker.model.SortOrder.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListPipelinesRequest
  ): zio.aws.sagemaker.model.ListPipelinesRequest.ReadOnly = new Wrapper(impl)
}
