package zio.aws.sagemaker.model
import zio.aws.sagemaker.model.primitives.{
  CreationTime,
  NextToken,
  LastModifiedTime,
  NotebookInstanceNameContains,
  CodeRepositoryContains,
  MaxResults,
  CodeRepositoryNameOrUrl,
  NotebookInstanceLifecycleConfigName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListNotebookInstancesRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    sortBy: Option[zio.aws.sagemaker.model.NotebookInstanceSortKey] = None,
    sortOrder: Option[zio.aws.sagemaker.model.NotebookInstanceSortOrder] = None,
    nameContains: Option[NotebookInstanceNameContains] = None,
    creationTimeBefore: Option[CreationTime] = None,
    creationTimeAfter: Option[CreationTime] = None,
    lastModifiedTimeBefore: Option[LastModifiedTime] = None,
    lastModifiedTimeAfter: Option[LastModifiedTime] = None,
    statusEquals: Option[zio.aws.sagemaker.model.NotebookInstanceStatus] = None,
    notebookInstanceLifecycleConfigNameContains: Option[
      NotebookInstanceLifecycleConfigName
    ] = None,
    defaultCodeRepositoryContains: Option[CodeRepositoryContains] = None,
    additionalCodeRepositoryEquals: Option[CodeRepositoryNameOrUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest = {
    import ListNotebookInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(
        nameContains.map(value =>
          NotebookInstanceNameContains.unwrap(value): java.lang.String
        )
      )(_.nameContains)
      .optionallyWith(
        creationTimeBefore.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeBefore)
      .optionallyWith(
        creationTimeAfter.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTimeAfter)
      .optionallyWith(
        lastModifiedTimeBefore.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeBefore)
      .optionallyWith(
        lastModifiedTimeAfter.map(value =>
          LastModifiedTime.unwrap(value): Instant
        )
      )(_.lastModifiedTimeAfter)
      .optionallyWith(statusEquals.map(value => value.unwrap))(_.statusEquals)
      .optionallyWith(
        notebookInstanceLifecycleConfigNameContains.map(value =>
          NotebookInstanceLifecycleConfigName.unwrap(value): java.lang.String
        )
      )(_.notebookInstanceLifecycleConfigNameContains)
      .optionallyWith(
        defaultCodeRepositoryContains.map(value =>
          CodeRepositoryContains.unwrap(value): java.lang.String
        )
      )(_.defaultCodeRepositoryContains)
      .optionallyWith(
        additionalCodeRepositoryEquals.map(value =>
          CodeRepositoryNameOrUrl.unwrap(value): java.lang.String
        )
      )(_.additionalCodeRepositoryEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.sagemaker.model.ListNotebookInstancesRequest.ReadOnly =
    zio.aws.sagemaker.model.ListNotebookInstancesRequest.wrap(buildAwsValue())
}
object ListNotebookInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sagemaker.model.ListNotebookInstancesRequest =
      zio.aws.sagemaker.model.ListNotebookInstancesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        nameContains.map(value => value),
        creationTimeBefore.map(value => value),
        creationTimeAfter.map(value => value),
        lastModifiedTimeBefore.map(value => value),
        lastModifiedTimeAfter.map(value => value),
        statusEquals.map(value => value),
        notebookInstanceLifecycleConfigNameContains.map(value => value),
        defaultCodeRepositoryContains.map(value => value),
        additionalCodeRepositoryEquals.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def sortBy: Option[zio.aws.sagemaker.model.NotebookInstanceSortKey]
    def sortOrder: Option[zio.aws.sagemaker.model.NotebookInstanceSortOrder]
    def nameContains: Option[NotebookInstanceNameContains]
    def creationTimeBefore: Option[CreationTime]
    def creationTimeAfter: Option[CreationTime]
    def lastModifiedTimeBefore: Option[LastModifiedTime]
    def lastModifiedTimeAfter: Option[LastModifiedTime]
    def statusEquals: Option[zio.aws.sagemaker.model.NotebookInstanceStatus]
    def notebookInstanceLifecycleConfigNameContains
        : Option[NotebookInstanceLifecycleConfigName]
    def defaultCodeRepositoryContains: Option[CodeRepositoryContains]
    def additionalCodeRepositoryEquals: Option[CodeRepositoryNameOrUrl]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceSortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[
      Any,
      AwsError,
      zio.aws.sagemaker.model.NotebookInstanceSortOrder
    ] = AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getNameContains: ZIO[Any, AwsError, NotebookInstanceNameContains] =
      AwsError.unwrapOptionField("nameContains", nameContains)
    def getCreationTimeBefore: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeBefore", creationTimeBefore)
    def getCreationTimeAfter: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTimeAfter", creationTimeAfter)
    def getLastModifiedTimeBefore: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField(
        "lastModifiedTimeBefore",
        lastModifiedTimeBefore
      )
    def getLastModifiedTimeAfter: ZIO[Any, AwsError, LastModifiedTime] =
      AwsError.unwrapOptionField("lastModifiedTimeAfter", lastModifiedTimeAfter)
    def getStatusEquals
        : ZIO[Any, AwsError, zio.aws.sagemaker.model.NotebookInstanceStatus] =
      AwsError.unwrapOptionField("statusEquals", statusEquals)
    def getNotebookInstanceLifecycleConfigNameContains
        : ZIO[Any, AwsError, NotebookInstanceLifecycleConfigName] =
      AwsError.unwrapOptionField(
        "notebookInstanceLifecycleConfigNameContains",
        notebookInstanceLifecycleConfigNameContains
      )
    def getDefaultCodeRepositoryContains
        : ZIO[Any, AwsError, CodeRepositoryContains] =
      AwsError.unwrapOptionField(
        "defaultCodeRepositoryContains",
        defaultCodeRepositoryContains
      )
    def getAdditionalCodeRepositoryEquals
        : ZIO[Any, AwsError, CodeRepositoryNameOrUrl] =
      AwsError.unwrapOptionField(
        "additionalCodeRepositoryEquals",
        additionalCodeRepositoryEquals
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
  ) extends zio.aws.sagemaker.model.ListNotebookInstancesRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.sagemaker.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.sagemaker.model.primitives.MaxResults(value))
    override val sortBy
        : Option[zio.aws.sagemaker.model.NotebookInstanceSortKey] = scala
      .Option(impl.sortBy())
      .map(value => zio.aws.sagemaker.model.NotebookInstanceSortKey.wrap(value))
    override val sortOrder
        : Option[zio.aws.sagemaker.model.NotebookInstanceSortOrder] = scala
      .Option(impl.sortOrder())
      .map(value =>
        zio.aws.sagemaker.model.NotebookInstanceSortOrder.wrap(value)
      )
    override val nameContains: Option[NotebookInstanceNameContains] = scala
      .Option(impl.nameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives.NotebookInstanceNameContains(value)
      )
    override val creationTimeBefore: Option[CreationTime] = scala
      .Option(impl.creationTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val creationTimeAfter: Option[CreationTime] = scala
      .Option(impl.creationTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.CreationTime(value))
    override val lastModifiedTimeBefore: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTimeBefore())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val lastModifiedTimeAfter: Option[LastModifiedTime] = scala
      .Option(impl.lastModifiedTimeAfter())
      .map(value => zio.aws.sagemaker.model.primitives.LastModifiedTime(value))
    override val statusEquals
        : Option[zio.aws.sagemaker.model.NotebookInstanceStatus] = scala
      .Option(impl.statusEquals())
      .map(value => zio.aws.sagemaker.model.NotebookInstanceStatus.wrap(value))
    override val notebookInstanceLifecycleConfigNameContains
        : Option[NotebookInstanceLifecycleConfigName] = scala
      .Option(impl.notebookInstanceLifecycleConfigNameContains())
      .map(value =>
        zio.aws.sagemaker.model.primitives
          .NotebookInstanceLifecycleConfigName(value)
      )
    override val defaultCodeRepositoryContains: Option[CodeRepositoryContains] =
      scala
        .Option(impl.defaultCodeRepositoryContains())
        .map(value =>
          zio.aws.sagemaker.model.primitives.CodeRepositoryContains(value)
        )
    override val additionalCodeRepositoryEquals
        : Option[CodeRepositoryNameOrUrl] = scala
      .Option(impl.additionalCodeRepositoryEquals())
      .map(value =>
        zio.aws.sagemaker.model.primitives.CodeRepositoryNameOrUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sagemaker.model.ListNotebookInstancesRequest
  ): zio.aws.sagemaker.model.ListNotebookInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
